/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.statements;

import com.github.cassandra.jdbc.internal.cassandra.auth.IRoleManager;
import com.github.cassandra.jdbc.internal.cassandra.auth.RoleResource;
import com.github.cassandra.jdbc.internal.cassandra.auth.Roles;
import com.github.cassandra.jdbc.internal.cassandra.config.DatabaseDescriptor;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnIdentifier;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnSpecification;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ResultSet;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.ListRolesStatement;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.BooleanType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.UTF8Type;
import com.github.cassandra.jdbc.internal.cassandra.transport.messages.ResultMessage;
import com.github.cassandra.jdbc.internal.google.common.collect.ImmutableList;
import java.util.List;

public class ListUsersStatement
extends ListRolesStatement {
    private static final String KS = "system_auth";
    private static final String CF = "users";
    private static final List<ColumnSpecification> metadata = ImmutableList.of(new ColumnSpecification("system_auth", "users", new ColumnIdentifier("name", true), UTF8Type.instance), new ColumnSpecification("system_auth", "users", new ColumnIdentifier("super", true), BooleanType.instance));

    @Override
    protected ResultMessage formatResults(List<RoleResource> sortedRoles) {
        ResultSet result = new ResultSet(metadata);
        IRoleManager roleManager = DatabaseDescriptor.getRoleManager();
        for (RoleResource role : sortedRoles) {
            if (!roleManager.canLogin(role)) continue;
            result.addColumnValue(UTF8Type.instance.decompose(role.getRoleName()));
            result.addColumnValue(BooleanType.instance.decompose(Roles.hasSuperuserStatus(role)));
        }
        return new ResultMessage.Rows(result);
    }
}

