/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.statements;

import com.github.cassandra.jdbc.internal.cassandra.auth.IRoleManager;
import com.github.cassandra.jdbc.internal.cassandra.auth.Permission;
import com.github.cassandra.jdbc.internal.cassandra.auth.RoleResource;
import com.github.cassandra.jdbc.internal.cassandra.config.DatabaseDescriptor;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnIdentifier;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnSpecification;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ResultSet;
import com.github.cassandra.jdbc.internal.cassandra.cql3.RoleName;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.AuthorizationStatement;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.BooleanType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.MapType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.UTF8Type;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.InvalidRequestException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.RequestExecutionException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.RequestValidationException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.UnauthorizedException;
import com.github.cassandra.jdbc.internal.cassandra.service.ClientState;
import com.github.cassandra.jdbc.internal.cassandra.transport.messages.ResultMessage;
import com.github.cassandra.jdbc.internal.google.common.collect.ImmutableList;
import com.github.cassandra.jdbc.internal.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ListRolesStatement
extends AuthorizationStatement {
    private static final String KS = "system_auth";
    private static final String CF = "roles";
    private static final MapType optionsType = MapType.getInstance(UTF8Type.instance, UTF8Type.instance, false);
    private static final List<ColumnSpecification> metadata = ImmutableList.of(new ColumnSpecification("system_auth", "roles", new ColumnIdentifier("role", true), UTF8Type.instance), new ColumnSpecification("system_auth", "roles", new ColumnIdentifier("super", true), BooleanType.instance), new ColumnSpecification("system_auth", "roles", new ColumnIdentifier("login", true), BooleanType.instance), new ColumnSpecification("system_auth", "roles", new ColumnIdentifier("options", true), optionsType));
    private final RoleResource grantee;
    private final boolean recursive;

    public ListRolesStatement() {
        this(new RoleName(), false);
    }

    public ListRolesStatement(RoleName grantee, boolean recursive) {
        this.grantee = grantee.hasName() ? RoleResource.role(grantee.getName()) : null;
        this.recursive = recursive;
    }

    @Override
    public void validate(ClientState state) throws UnauthorizedException, InvalidRequestException {
        state.ensureNotAnonymous();
        if (this.grantee != null && !DatabaseDescriptor.getRoleManager().isExistingRole(this.grantee)) {
            throw new InvalidRequestException(String.format("%s doesn't exist", this.grantee));
        }
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException {
    }

    @Override
    public ResultMessage execute(ClientState state) throws RequestValidationException, RequestExecutionException {
        boolean hasRootLevelSelect = DatabaseDescriptor.getAuthorizer().authorize(state.getUser(), RoleResource.root()).contains((Object)Permission.DESCRIBE);
        if (hasRootLevelSelect) {
            if (this.grantee == null) {
                return this.resultMessage(DatabaseDescriptor.getRoleManager().getAllRoles());
            }
            return this.resultMessage(DatabaseDescriptor.getRoleManager().getRoles(this.grantee, this.recursive));
        }
        RoleResource currentUser = RoleResource.role(state.getUser().getName());
        if (this.grantee == null) {
            return this.resultMessage(DatabaseDescriptor.getRoleManager().getRoles(currentUser, this.recursive));
        }
        if (DatabaseDescriptor.getRoleManager().getRoles(currentUser, true).contains(this.grantee)) {
            return this.resultMessage(DatabaseDescriptor.getRoleManager().getRoles(this.grantee, this.recursive));
        }
        throw new UnauthorizedException(String.format("You are not authorized to view roles granted to %s ", this.grantee.getRoleName()));
    }

    private ResultMessage resultMessage(Set<RoleResource> roles) {
        if (roles.isEmpty()) {
            return new ResultMessage.Void();
        }
        ArrayList<RoleResource> sorted = Lists.newArrayList(roles);
        Collections.sort(sorted);
        return this.formatResults(sorted);
    }

    protected ResultMessage formatResults(List<RoleResource> sortedRoles) {
        ResultSet result = new ResultSet(metadata);
        IRoleManager roleManager = DatabaseDescriptor.getRoleManager();
        for (RoleResource role : sortedRoles) {
            result.addColumnValue(UTF8Type.instance.decompose(role.getRoleName()));
            result.addColumnValue(BooleanType.instance.decompose(roleManager.isSuper(role)));
            result.addColumnValue(BooleanType.instance.decompose(roleManager.canLogin(role)));
            result.addColumnValue(optionsType.decompose(roleManager.getCustomOptions(role)));
        }
        return new ResultMessage.Rows(result);
    }
}

