/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.statements;

import com.github.cassandra.jdbc.internal.cassandra.auth.IResource;
import com.github.cassandra.jdbc.internal.cassandra.auth.Permission;
import com.github.cassandra.jdbc.internal.cassandra.auth.PermissionDetails;
import com.github.cassandra.jdbc.internal.cassandra.auth.Resources;
import com.github.cassandra.jdbc.internal.cassandra.auth.RoleResource;
import com.github.cassandra.jdbc.internal.cassandra.config.DatabaseDescriptor;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnIdentifier;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnSpecification;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ResultSet;
import com.github.cassandra.jdbc.internal.cassandra.cql3.RoleName;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.AuthorizationStatement;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.UTF8Type;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.InvalidRequestException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.RequestExecutionException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.RequestValidationException;
import com.github.cassandra.jdbc.internal.cassandra.service.ClientState;
import com.github.cassandra.jdbc.internal.cassandra.transport.messages.ResultMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ListPermissionsStatement
extends AuthorizationStatement {
    private static final String KS = "system_auth";
    private static final String CF = "permissions";
    private static final List<ColumnSpecification> metadata;
    protected final Set<Permission> permissions;
    protected IResource resource;
    protected final boolean recursive;
    private final RoleResource grantee;

    public ListPermissionsStatement(Set<Permission> permissions, IResource resource, RoleName grantee, boolean recursive) {
        this.permissions = permissions;
        this.resource = resource;
        this.recursive = recursive;
        this.grantee = grantee.hasName() ? RoleResource.role(grantee.getName()) : null;
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        state.ensureNotAnonymous();
        if (this.resource != null) {
            this.resource = ListPermissionsStatement.maybeCorrectResource(this.resource, state);
            if (!this.resource.exists()) {
                throw new InvalidRequestException(String.format("%s doesn't exist", this.resource));
            }
        }
        if (this.grantee != null && !DatabaseDescriptor.getRoleManager().isExistingRole(this.grantee)) {
            throw new InvalidRequestException(String.format("%s doesn't exist", this.grantee));
        }
    }

    @Override
    public void checkAccess(ClientState state) {
    }

    @Override
    public ResultMessage execute(ClientState state) throws RequestValidationException, RequestExecutionException {
        ArrayList<PermissionDetails> details = new ArrayList<PermissionDetails>();
        if (this.resource != null && this.recursive) {
            for (IResource iResource : Resources.chain(this.resource)) {
                details.addAll(this.list(state, iResource));
            }
        } else {
            details.addAll(this.list(state, this.resource));
        }
        Collections.sort(details);
        return this.resultMessage(details);
    }

    private Set<PermissionDetails> list(ClientState state, IResource resource) throws RequestValidationException, RequestExecutionException {
        try {
            return DatabaseDescriptor.getAuthorizer().list(state.getUser(), this.permissions, resource, this.grantee);
        }
        catch (UnsupportedOperationException e) {
            throw new InvalidRequestException(e.getMessage());
        }
    }

    private ResultMessage resultMessage(List<PermissionDetails> details) {
        if (details.isEmpty()) {
            return new ResultMessage.Void();
        }
        ResultSet result = new ResultSet(metadata);
        for (PermissionDetails pd : details) {
            result.addColumnValue(UTF8Type.instance.decompose(pd.grantee));
            result.addColumnValue(UTF8Type.instance.decompose(pd.grantee));
            result.addColumnValue(UTF8Type.instance.decompose(pd.resource.toString()));
            result.addColumnValue(UTF8Type.instance.decompose(pd.permission.toString()));
        }
        return new ResultMessage.Rows(result);
    }

    static {
        ArrayList<ColumnSpecification> columns = new ArrayList<ColumnSpecification>(4);
        columns.add(new ColumnSpecification(KS, CF, new ColumnIdentifier("role", true), UTF8Type.instance));
        columns.add(new ColumnSpecification(KS, CF, new ColumnIdentifier("username", true), UTF8Type.instance));
        columns.add(new ColumnSpecification(KS, CF, new ColumnIdentifier("resource", true), UTF8Type.instance));
        columns.add(new ColumnSpecification(KS, CF, new ColumnIdentifier("permission", true), UTF8Type.instance));
        metadata = Collections.unmodifiableList(columns);
    }
}

