/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.statements;

import com.github.cassandra.jdbc.internal.cassandra.auth.Permission;
import com.github.cassandra.jdbc.internal.cassandra.config.CFMetaData;
import com.github.cassandra.jdbc.internal.cassandra.config.ColumnDefinition;
import com.github.cassandra.jdbc.internal.cassandra.config.Schema;
import com.github.cassandra.jdbc.internal.cassandra.cql3.UTName;
import com.github.cassandra.jdbc.internal.cassandra.cql3.functions.Function;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.SchemaAlteringStatement;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.AbstractType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.UserType;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.ConfigurationException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.InvalidRequestException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.RequestValidationException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.UnauthorizedException;
import com.github.cassandra.jdbc.internal.cassandra.schema.KeyspaceMetadata;
import com.github.cassandra.jdbc.internal.cassandra.service.ClientState;
import com.github.cassandra.jdbc.internal.cassandra.service.MigrationManager;
import com.github.cassandra.jdbc.internal.cassandra.transport.Event;

public class DropTypeStatement
extends SchemaAlteringStatement {
    private final UTName name;
    private final boolean ifExists;

    public DropTypeStatement(UTName name, boolean ifExists) {
        this.name = name;
        this.ifExists = ifExists;
    }

    @Override
    public void prepareKeyspace(ClientState state) throws InvalidRequestException {
        if (!this.name.hasKeyspace()) {
            this.name.setKeyspace(state.getKeyspace());
        }
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        state.hasKeyspaceAccess(this.keyspace(), Permission.DROP);
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        KeyspaceMetadata ksm = Schema.instance.getKSMetaData(this.name.getKeyspace());
        if (ksm == null) {
            if (this.ifExists) {
                return;
            }
            throw new InvalidRequestException(String.format("Cannot drop type in unknown keyspace %s", this.name.getKeyspace()));
        }
        if (!ksm.types.get(this.name.getUserTypeName()).isPresent()) {
            if (this.ifExists) {
                return;
            }
            throw new InvalidRequestException(String.format("No user type named %s exists.", this.name));
        }
        for (Function function : ksm.functions) {
            if (function.returnType().referencesUserType(this.name.getStringTypeName())) {
                throw new InvalidRequestException(String.format("Cannot drop user type %s as it is still used by function %s", this.name, function));
            }
            for (AbstractType<?> argType : function.argTypes()) {
                if (!argType.referencesUserType(this.name.getStringTypeName())) continue;
                throw new InvalidRequestException(String.format("Cannot drop user type %s as it is still used by function %s", this.name, function));
            }
        }
        for (UserType ut : ksm.types) {
            if (ut.name.equals(this.name.getUserTypeName()) || !ut.referencesUserType(this.name.getStringTypeName())) continue;
            throw new InvalidRequestException(String.format("Cannot drop user type %s as it is still used by user type %s", this.name, ut.getNameAsString()));
        }
        for (CFMetaData cfm : ksm.tablesAndViews()) {
            for (ColumnDefinition def : cfm.allColumns()) {
                if (!def.type.referencesUserType(this.name.getStringTypeName())) continue;
                throw new InvalidRequestException(String.format("Cannot drop user type %s as it is still used by table %s.%s", this.name, cfm.ksName, cfm.cfName));
            }
        }
    }

    @Override
    public String keyspace() {
        return this.name.getKeyspace();
    }

    @Override
    public Event.SchemaChange announceMigration(boolean isLocalOnly) throws InvalidRequestException, ConfigurationException {
        KeyspaceMetadata ksm = Schema.instance.getKSMetaData(this.name.getKeyspace());
        if (ksm == null) {
            return null;
        }
        UserType toDrop = ksm.types.getNullable(this.name.getUserTypeName());
        if (toDrop == null) {
            return null;
        }
        MigrationManager.announceTypeDrop((UserType)toDrop, (boolean)isLocalOnly);
        return new Event.SchemaChange(Event.SchemaChange.Change.DROPPED, Event.SchemaChange.Target.TYPE, this.keyspace(), this.name.getStringTypeName());
    }
}

