/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.statements;

import com.github.cassandra.jdbc.internal.cassandra.config.CFMetaData;
import com.github.cassandra.jdbc.internal.cassandra.config.Schema;
import com.github.cassandra.jdbc.internal.cassandra.cql3.CFName;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.SchemaAlteringStatement;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.ConfigurationException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.InvalidRequestException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.RequestValidationException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.UnauthorizedException;
import com.github.cassandra.jdbc.internal.cassandra.schema.Triggers;
import com.github.cassandra.jdbc.internal.cassandra.service.ClientState;
import com.github.cassandra.jdbc.internal.cassandra.service.MigrationManager;
import com.github.cassandra.jdbc.internal.cassandra.thrift.ThriftValidation;
import com.github.cassandra.jdbc.internal.cassandra.transport.Event;
import com.github.cassandra.jdbc.internal.slf4j.Logger;
import com.github.cassandra.jdbc.internal.slf4j.LoggerFactory;

public class DropTriggerStatement
extends SchemaAlteringStatement {
    private static final Logger logger = LoggerFactory.getLogger(DropTriggerStatement.class);
    private final String triggerName;
    private final boolean ifExists;

    public DropTriggerStatement(CFName name, String triggerName, boolean ifExists) {
        super(name);
        this.triggerName = triggerName;
        this.ifExists = ifExists;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException {
        state.ensureIsSuper("Only superusers are allowed to perfrom DROP TRIGGER queries");
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        ThriftValidation.validateColumnFamily((String)this.keyspace(), (String)this.columnFamily());
    }

    @Override
    public Event.SchemaChange announceMigration(boolean isLocalOnly) throws ConfigurationException, InvalidRequestException {
        CFMetaData cfm = Schema.instance.getCFMetaData(this.keyspace(), this.columnFamily()).copy();
        Triggers triggers = cfm.getTriggers();
        if (!triggers.get(this.triggerName).isPresent()) {
            if (this.ifExists) {
                return null;
            }
            throw new InvalidRequestException(String.format("Trigger %s was not found", this.triggerName));
        }
        logger.info("Dropping trigger with name {}", (Object)this.triggerName);
        cfm.triggers(triggers.without(this.triggerName));
        MigrationManager.announceColumnFamilyUpdate((CFMetaData)cfm, (boolean)false, (boolean)isLocalOnly);
        return new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, Event.SchemaChange.Target.TABLE, this.keyspace(), this.columnFamily());
    }
}

