/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.statements;

import com.github.cassandra.jdbc.internal.cassandra.auth.Permission;
import com.github.cassandra.jdbc.internal.cassandra.config.CFMetaData;
import com.github.cassandra.jdbc.internal.cassandra.config.Schema;
import com.github.cassandra.jdbc.internal.cassandra.config.ViewDefinition;
import com.github.cassandra.jdbc.internal.cassandra.cql3.CFName;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.SchemaAlteringStatement;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.ConfigurationException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.InvalidRequestException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.UnauthorizedException;
import com.github.cassandra.jdbc.internal.cassandra.schema.KeyspaceMetadata;
import com.github.cassandra.jdbc.internal.cassandra.service.ClientState;
import com.github.cassandra.jdbc.internal.cassandra.service.MigrationManager;
import com.github.cassandra.jdbc.internal.cassandra.transport.Event;

public class DropTableStatement
extends SchemaAlteringStatement {
    private final boolean ifExists;

    public DropTableStatement(CFName name, boolean ifExists) {
        super(name);
        this.ifExists = ifExists;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        block2: {
            try {
                state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.DROP);
            }
            catch (InvalidRequestException e) {
                if (this.ifExists) break block2;
                throw e;
            }
        }
    }

    @Override
    public void validate(ClientState state) {
    }

    @Override
    public Event.SchemaChange announceMigration(boolean isLocalOnly) throws ConfigurationException {
        try {
            KeyspaceMetadata ksm = Schema.instance.getKSMetaData(this.keyspace());
            if (ksm == null) {
                throw new ConfigurationException(String.format("Cannot drop table in unknown keyspace '%s'", this.keyspace()));
            }
            CFMetaData cfm = ksm.getTableOrViewNullable(this.columnFamily());
            if (cfm != null) {
                if (cfm.isView()) {
                    throw new InvalidRequestException("Cannot use DROP TABLE on Materialized View");
                }
                boolean rejectDrop = false;
                StringBuilder messageBuilder = new StringBuilder();
                for (ViewDefinition def : ksm.views) {
                    if (!def.baseTableId.equals(cfm.cfId)) continue;
                    if (rejectDrop) {
                        messageBuilder.append(',');
                    }
                    rejectDrop = true;
                    messageBuilder.append(def.viewName);
                }
                if (rejectDrop) {
                    throw new InvalidRequestException(String.format("Cannot drop table when materialized views still depend on it (%s.{%s})", this.keyspace(), messageBuilder.toString()));
                }
            }
            MigrationManager.announceColumnFamilyDrop((String)this.keyspace(), (String)this.columnFamily(), (boolean)isLocalOnly);
            return new Event.SchemaChange(Event.SchemaChange.Change.DROPPED, Event.SchemaChange.Target.TABLE, this.keyspace(), this.columnFamily());
        }
        catch (ConfigurationException e) {
            if (this.ifExists) {
                return null;
            }
            throw e;
        }
    }
}

