/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.statements;

import com.github.cassandra.jdbc.internal.cassandra.auth.AuthenticatedUser;
import com.github.cassandra.jdbc.internal.cassandra.auth.Permission;
import com.github.cassandra.jdbc.internal.cassandra.auth.RoleResource;
import com.github.cassandra.jdbc.internal.cassandra.auth.Roles;
import com.github.cassandra.jdbc.internal.cassandra.config.DatabaseDescriptor;
import com.github.cassandra.jdbc.internal.cassandra.cql3.RoleName;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.AuthenticationStatement;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.InvalidRequestException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.RequestExecutionException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.RequestValidationException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.UnauthorizedException;
import com.github.cassandra.jdbc.internal.cassandra.service.ClientState;
import com.github.cassandra.jdbc.internal.cassandra.transport.messages.ResultMessage;

public class DropRoleStatement
extends AuthenticationStatement {
    private final RoleResource role;
    private final boolean ifExists;

    public DropRoleStatement(RoleName name, boolean ifExists) {
        this.role = RoleResource.role(name.getName());
        this.ifExists = ifExists;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException {
        super.checkPermission(state, Permission.DROP, this.role);
        if (DatabaseDescriptor.getRoleManager().isExistingRole(this.role) && Roles.hasSuperuserStatus(this.role) && !state.getUser().isSuper()) {
            throw new UnauthorizedException("Only superusers can drop a role with superuser status");
        }
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        state.ensureNotAnonymous();
        if (!this.ifExists && !DatabaseDescriptor.getRoleManager().isExistingRole(this.role)) {
            throw new InvalidRequestException(String.format("%s doesn't exist", this.role.getRoleName()));
        }
        AuthenticatedUser user = state.getUser();
        if (user != null && user.getName().equals(this.role.getRoleName())) {
            throw new InvalidRequestException("Cannot DROP primary role for current login");
        }
    }

    @Override
    public ResultMessage execute(ClientState state) throws RequestValidationException, RequestExecutionException {
        if (this.ifExists && !DatabaseDescriptor.getRoleManager().isExistingRole(this.role)) {
            return null;
        }
        DatabaseDescriptor.getRoleManager().dropRole(state.getUser(), this.role);
        DatabaseDescriptor.getAuthorizer().revokeAllFrom(this.role);
        DatabaseDescriptor.getAuthorizer().revokeAllOn(this.role);
        return null;
    }
}

