/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.statements;

import com.github.cassandra.jdbc.internal.cassandra.auth.Permission;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.SchemaAlteringStatement;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.ConfigurationException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.InvalidRequestException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.RequestValidationException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.UnauthorizedException;
import com.github.cassandra.jdbc.internal.cassandra.service.ClientState;
import com.github.cassandra.jdbc.internal.cassandra.service.MigrationManager;
import com.github.cassandra.jdbc.internal.cassandra.thrift.ThriftValidation;
import com.github.cassandra.jdbc.internal.cassandra.transport.Event;

public class DropKeyspaceStatement
extends SchemaAlteringStatement {
    private final String keyspace;
    private final boolean ifExists;

    public DropKeyspaceStatement(String keyspace, boolean ifExists) {
        this.keyspace = keyspace;
        this.ifExists = ifExists;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        state.hasKeyspaceAccess(this.keyspace, Permission.DROP);
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        ThriftValidation.validateKeyspaceNotSystem((String)this.keyspace);
    }

    @Override
    public String keyspace() {
        return this.keyspace;
    }

    @Override
    public Event.SchemaChange announceMigration(boolean isLocalOnly) throws ConfigurationException {
        try {
            MigrationManager.announceKeyspaceDrop((String)this.keyspace, (boolean)isLocalOnly);
            return new Event.SchemaChange(Event.SchemaChange.Change.DROPPED, this.keyspace());
        }
        catch (ConfigurationException e) {
            if (this.ifExists) {
                return null;
            }
            throw e;
        }
    }
}

