/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.statements;

import com.github.cassandra.jdbc.internal.cassandra.auth.Permission;
import com.github.cassandra.jdbc.internal.cassandra.config.CFMetaData;
import com.github.cassandra.jdbc.internal.cassandra.config.Schema;
import com.github.cassandra.jdbc.internal.cassandra.cql3.IndexName;
import com.github.cassandra.jdbc.internal.cassandra.cql3.QueryOptions;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.SchemaAlteringStatement;
import com.github.cassandra.jdbc.internal.cassandra.db.KeyspaceNotDefinedException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.ConfigurationException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.InvalidRequestException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.RequestValidationException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.UnauthorizedException;
import com.github.cassandra.jdbc.internal.cassandra.schema.KeyspaceMetadata;
import com.github.cassandra.jdbc.internal.cassandra.service.ClientState;
import com.github.cassandra.jdbc.internal.cassandra.service.MigrationManager;
import com.github.cassandra.jdbc.internal.cassandra.service.QueryState;
import com.github.cassandra.jdbc.internal.cassandra.transport.Event;
import com.github.cassandra.jdbc.internal.cassandra.transport.messages.ResultMessage;

public class DropIndexStatement
extends SchemaAlteringStatement {
    public final String indexName;
    public final boolean ifExists;

    public DropIndexStatement(IndexName indexName, boolean ifExists) {
        super(indexName.getCfName());
        this.indexName = indexName.getIdx();
        this.ifExists = ifExists;
    }

    @Override
    public String columnFamily() {
        CFMetaData cfm = this.lookupIndexedTable();
        return cfm == null ? null : cfm.cfName;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        CFMetaData cfm = this.lookupIndexedTable();
        if (cfm == null) {
            return;
        }
        state.hasColumnFamilyAccess(cfm.ksName, cfm.cfName, Permission.ALTER);
    }

    @Override
    public void validate(ClientState state) {
    }

    @Override
    public ResultMessage execute(QueryState state, QueryOptions options) throws RequestValidationException {
        Event.SchemaChange ce = this.announceMigration(false);
        return ce == null ? null : new ResultMessage.SchemaChange(ce);
    }

    @Override
    public Event.SchemaChange announceMigration(boolean isLocalOnly) throws InvalidRequestException, ConfigurationException {
        CFMetaData cfm = this.lookupIndexedTable();
        if (cfm == null) {
            return null;
        }
        CFMetaData updatedCfm = cfm.copy();
        updatedCfm.indexes(updatedCfm.getIndexes().without(this.indexName));
        MigrationManager.announceColumnFamilyUpdate((CFMetaData)updatedCfm, (boolean)false, (boolean)isLocalOnly);
        return new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, Event.SchemaChange.Target.TABLE, cfm.ksName, cfm.cfName);
    }

    private CFMetaData lookupIndexedTable() {
        KeyspaceMetadata ksm = Schema.instance.getKSMetaData(this.keyspace());
        if (ksm == null) {
            throw new KeyspaceNotDefinedException("Keyspace " + this.keyspace() + " does not exist");
        }
        return ksm.findIndexedTable(this.indexName).orElseGet(() -> {
            if (this.ifExists) {
                return null;
            }
            throw new InvalidRequestException(String.format("Index '%s' could not be found in any of the tables of keyspace '%s'", this.indexName, this.keyspace()));
        });
    }
}

