/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.statements;

import com.github.cassandra.jdbc.internal.cassandra.auth.FunctionResource;
import com.github.cassandra.jdbc.internal.cassandra.auth.IResource;
import com.github.cassandra.jdbc.internal.cassandra.auth.Permission;
import com.github.cassandra.jdbc.internal.cassandra.config.Schema;
import com.github.cassandra.jdbc.internal.cassandra.cql3.CQL3Type;
import com.github.cassandra.jdbc.internal.cassandra.cql3.functions.Function;
import com.github.cassandra.jdbc.internal.cassandra.cql3.functions.FunctionName;
import com.github.cassandra.jdbc.internal.cassandra.cql3.functions.ScalarFunction;
import com.github.cassandra.jdbc.internal.cassandra.cql3.functions.UDFunction;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.ParsedStatement;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.SchemaAlteringStatement;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.AbstractType;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.InvalidRequestException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.RequestValidationException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.UnauthorizedException;
import com.github.cassandra.jdbc.internal.cassandra.schema.KeyspaceMetadata;
import com.github.cassandra.jdbc.internal.cassandra.service.ClientState;
import com.github.cassandra.jdbc.internal.cassandra.service.MigrationManager;
import com.github.cassandra.jdbc.internal.cassandra.thrift.ThriftValidation;
import com.github.cassandra.jdbc.internal.cassandra.transport.Event;
import com.github.cassandra.jdbc.internal.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class DropFunctionStatement
extends SchemaAlteringStatement {
    private FunctionName functionName;
    private final boolean ifExists;
    private final List<CQL3Type.Raw> argRawTypes;
    private final boolean argsPresent;
    private List<AbstractType<?>> argTypes;

    public DropFunctionStatement(FunctionName functionName, List<CQL3Type.Raw> argRawTypes, boolean argsPresent, boolean ifExists) {
        this.functionName = functionName;
        this.argRawTypes = argRawTypes;
        this.argsPresent = argsPresent;
        this.ifExists = ifExists;
    }

    @Override
    public ParsedStatement.Prepared prepare() throws InvalidRequestException {
        if (Schema.instance.getKSMetaData(this.functionName.keyspace) != null) {
            this.argTypes = new ArrayList(this.argRawTypes.size());
            for (CQL3Type.Raw rawType : this.argRawTypes) {
                if (rawType.isFrozen()) {
                    throw new InvalidRequestException("The function arguments should not be frozen; remove the frozen<> modifier");
                }
                if (!rawType.canBeNonFrozen()) {
                    rawType.freeze();
                }
                this.argTypes.add(rawType.prepare(this.functionName.keyspace).getType());
            }
        }
        return super.prepare();
    }

    @Override
    public void prepareKeyspace(ClientState state) throws InvalidRequestException {
        if (!this.functionName.hasKeyspace() && state.getRawKeyspace() != null) {
            this.functionName = new FunctionName(state.getKeyspace(), this.functionName.name);
        }
        if (!this.functionName.hasKeyspace()) {
            throw new InvalidRequestException("Functions must be fully qualified with a keyspace name if a keyspace is not set for the session");
        }
        ThriftValidation.validateKeyspaceNotSystem((String)this.functionName.keyspace);
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        Function function = this.findFunction();
        if (function == null) {
            if (!this.ifExists) {
                throw new InvalidRequestException(String.format("Unconfigured function %s.%s(%s)", this.functionName.keyspace, this.functionName.name, Joiner.on(",").join(this.argRawTypes)));
            }
        } else {
            state.ensureHasPermission(Permission.DROP, (IResource)FunctionResource.function(function.name().keyspace, function.name().name, function.argTypes()));
        }
    }

    @Override
    public void validate(ClientState state) {
        Collection<Function> olds = Schema.instance.getFunctions(this.functionName);
        if (!this.argsPresent && olds != null && olds.size() > 1) {
            throw new InvalidRequestException(String.format("'DROP FUNCTION %s' matches multiple function definitions; specify the argument types by issuing a statement like 'DROP FUNCTION %s (type, type, ...)'. Hint: use cqlsh 'DESCRIBE FUNCTION %s' command to find all overloads", this.functionName, this.functionName, this.functionName));
        }
    }

    @Override
    public Event.SchemaChange announceMigration(boolean isLocalOnly) throws RequestValidationException {
        Function old = this.findFunction();
        if (old == null) {
            if (this.ifExists) {
                return null;
            }
            throw new InvalidRequestException(this.getMissingFunctionError());
        }
        KeyspaceMetadata ksm = Schema.instance.getKSMetaData(old.name().keyspace);
        Collection referrers = ksm.functions.aggregatesUsingFunction(old);
        if (!referrers.isEmpty()) {
            throw new InvalidRequestException(String.format("Function '%s' still referenced by %s", old, referrers));
        }
        MigrationManager.announceFunctionDrop((UDFunction)((UDFunction)old), (boolean)isLocalOnly);
        return new Event.SchemaChange(Event.SchemaChange.Change.DROPPED, Event.SchemaChange.Target.FUNCTION, old.name().keyspace, old.name().name, AbstractType.asCQLTypeStringList(old.argTypes()));
    }

    private String getMissingFunctionError() {
        StringBuilder sb = new StringBuilder("Cannot drop non existing function '");
        sb.append(this.functionName);
        if (this.argsPresent) {
            sb.append(Joiner.on(", ").join(this.argRawTypes));
        }
        sb.append('\'');
        return sb.toString();
    }

    private Function findFunction() {
        Function old;
        if (this.argsPresent) {
            if (this.argTypes == null) {
                return null;
            }
            old = Schema.instance.findFunction(this.functionName, this.argTypes).orElse(null);
            if (old == null || !(old instanceof ScalarFunction)) {
                return null;
            }
        } else {
            Collection<Function> olds = Schema.instance.getFunctions(this.functionName);
            if (olds == null || olds.isEmpty() || !(olds.iterator().next() instanceof ScalarFunction)) {
                return null;
            }
            old = olds.iterator().next();
        }
        return old;
    }
}

