/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.statements;

import com.github.cassandra.jdbc.internal.cassandra.config.CFMetaData;
import com.github.cassandra.jdbc.internal.cassandra.config.ColumnDefinition;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Attributes;
import com.github.cassandra.jdbc.internal.cassandra.cql3.CFName;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnCondition;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnIdentifier;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Conditions;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Operation;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Operations;
import com.github.cassandra.jdbc.internal.cassandra.cql3.UpdateParameters;
import com.github.cassandra.jdbc.internal.cassandra.cql3.VariableSpecifications;
import com.github.cassandra.jdbc.internal.cassandra.cql3.WhereClause;
import com.github.cassandra.jdbc.internal.cassandra.cql3.restrictions.StatementRestrictions;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.ModificationStatement;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.RequestValidations;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.StatementType;
import com.github.cassandra.jdbc.internal.cassandra.db.Clustering;
import com.github.cassandra.jdbc.internal.cassandra.db.Slice;
import com.github.cassandra.jdbc.internal.cassandra.db.partitions.PartitionUpdate;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.InvalidRequestException;
import com.github.cassandra.jdbc.internal.cassandra.utils.Pair;
import java.util.List;

public class DeleteStatement
extends ModificationStatement {
    private DeleteStatement(int boundTerms, CFMetaData cfm, Operations operations, StatementRestrictions restrictions, Conditions conditions, Attributes attrs) {
        super(StatementType.DELETE, boundTerms, cfm, operations, restrictions, conditions, attrs);
    }

    @Override
    public void addUpdateForKey(PartitionUpdate update, Clustering clustering, UpdateParameters params) throws InvalidRequestException {
        List<Operation> regularDeletions = this.getRegularOperations();
        List<Operation> staticDeletions = this.getStaticOperations();
        if (regularDeletions.isEmpty() && staticDeletions.isEmpty()) {
            if (clustering.size() == 0) {
                update.addPartitionDeletion(params.deletionTime());
            } else if (clustering.size() == this.cfm.clusteringColumns().size()) {
                params.newRow(clustering);
                params.addRowDeletion();
                update.add(params.buildRow());
            } else {
                update.add(params.makeRangeTombstone(this.cfm.comparator, clustering));
            }
        } else {
            if (!regularDeletions.isEmpty()) {
                RequestValidations.checkFalse(clustering.size() == 0 && this.cfm.clusteringColumns().size() != 0, "Range deletions are not supported for specific columns");
                params.newRow(clustering);
                for (Operation op : regularDeletions) {
                    op.execute(update.partitionKey(), params);
                }
                update.add(params.buildRow());
            }
            if (!staticDeletions.isEmpty()) {
                params.newRow(Clustering.STATIC_CLUSTERING);
                for (Operation op : staticDeletions) {
                    op.execute(update.partitionKey(), params);
                }
                update.add(params.buildRow());
            }
        }
    }

    @Override
    public void addUpdateForKey(PartitionUpdate update, Slice slice, UpdateParameters params) {
        List<Operation> regularDeletions = this.getRegularOperations();
        List<Operation> staticDeletions = this.getStaticOperations();
        RequestValidations.checkTrue(regularDeletions.isEmpty() && staticDeletions.isEmpty(), "Range deletions are not supported for specific columns");
        update.add(params.makeRangeTombstone(slice));
    }

    public static class Parsed
    extends ModificationStatement.Parsed {
        private final List<Operation.RawDeletion> deletions;
        private final WhereClause whereClause;

        public Parsed(CFName name, Attributes.Raw attrs, List<Operation.RawDeletion> deletions, WhereClause whereClause, List<Pair<ColumnIdentifier.Raw, ColumnCondition.Raw>> conditions, boolean ifExists) {
            super(name, StatementType.DELETE, attrs, conditions, false, ifExists);
            this.deletions = deletions;
            this.whereClause = whereClause;
        }

        @Override
        protected ModificationStatement prepareInternal(CFMetaData cfm, VariableSpecifications boundNames, Conditions conditions, Attributes attrs) {
            Operations operations = new Operations(this.type);
            for (Operation.RawDeletion deletion : this.deletions) {
                ColumnDefinition def = Parsed.getColumnDefinition(cfm, deletion.affectedColumn());
                RequestValidations.checkFalse(def.isPrimaryKeyColumn(), "Invalid identifier %s for deletion (should not be a PRIMARY KEY part)", def.name);
                Operation op = deletion.prepare(cfm.ksName, def);
                op.collectMarkerSpecification(boundNames);
                operations.add(op);
            }
            StatementRestrictions restrictions = this.newRestrictions(cfm, boundNames, operations, this.whereClause, conditions);
            DeleteStatement stmt = new DeleteStatement(boundNames.size(), cfm, operations, restrictions, conditions, attrs);
            if (stmt.hasConditions()) {
                RequestValidations.checkTrue(restrictions.hasAllPKColumnsRestrictedByEqualities(), "DELETE statements must restrict all PRIMARY KEY columns with equality relations in order to use IF conditions");
            }
            return stmt;
        }
    }
}

