/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.statements;

import com.github.cassandra.jdbc.internal.cassandra.config.CFMetaData;
import com.github.cassandra.jdbc.internal.cassandra.config.Schema;
import com.github.cassandra.jdbc.internal.cassandra.cql3.CFName;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.SchemaAlteringStatement;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.ConfigurationException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.InvalidRequestException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.RequestValidationException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.UnauthorizedException;
import com.github.cassandra.jdbc.internal.cassandra.schema.TriggerMetadata;
import com.github.cassandra.jdbc.internal.cassandra.schema.Triggers;
import com.github.cassandra.jdbc.internal.cassandra.service.ClientState;
import com.github.cassandra.jdbc.internal.cassandra.service.MigrationManager;
import com.github.cassandra.jdbc.internal.cassandra.thrift.ThriftValidation;
import com.github.cassandra.jdbc.internal.cassandra.transport.Event;
import com.github.cassandra.jdbc.internal.cassandra.triggers.TriggerExecutor;
import com.github.cassandra.jdbc.internal.slf4j.Logger;
import com.github.cassandra.jdbc.internal.slf4j.LoggerFactory;

public class CreateTriggerStatement
extends SchemaAlteringStatement {
    private static final Logger logger = LoggerFactory.getLogger(CreateTriggerStatement.class);
    private final String triggerName;
    private final String triggerClass;
    private final boolean ifNotExists;

    public CreateTriggerStatement(CFName name, String triggerName, String clazz, boolean ifNotExists) {
        super(name);
        this.triggerName = triggerName;
        this.triggerClass = clazz;
        this.ifNotExists = ifNotExists;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException {
        state.ensureIsSuper("Only superusers are allowed to perform CREATE TRIGGER queries");
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        CFMetaData cfm = ThriftValidation.validateColumnFamily((String)this.keyspace(), (String)this.columnFamily());
        if (cfm.isView()) {
            throw new InvalidRequestException("Cannot CREATE TRIGGER against a materialized view");
        }
        try {
            TriggerExecutor.instance.loadTriggerInstance(this.triggerClass);
        }
        catch (Exception e) {
            throw new ConfigurationException(String.format("Trigger class '%s' doesn't exist", this.triggerClass));
        }
    }

    @Override
    public Event.SchemaChange announceMigration(boolean isLocalOnly) throws ConfigurationException, InvalidRequestException {
        CFMetaData cfm = Schema.instance.getCFMetaData(this.keyspace(), this.columnFamily()).copy();
        Triggers triggers = cfm.getTriggers();
        if (triggers.get(this.triggerName).isPresent()) {
            if (this.ifNotExists) {
                return null;
            }
            throw new InvalidRequestException(String.format("Trigger %s already exists", this.triggerName));
        }
        cfm.triggers(triggers.with(TriggerMetadata.create((String)this.triggerName, (String)this.triggerClass)));
        logger.info("Adding trigger with name {} and class {}", (Object)this.triggerName, (Object)this.triggerClass);
        MigrationManager.announceColumnFamilyUpdate((CFMetaData)cfm, (boolean)false, (boolean)isLocalOnly);
        return new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, Event.SchemaChange.Target.TABLE, this.keyspace(), this.columnFamily());
    }
}

