/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.statements;

import com.github.cassandra.jdbc.internal.cassandra.auth.AuthenticatedUser;
import com.github.cassandra.jdbc.internal.cassandra.auth.Permission;
import com.github.cassandra.jdbc.internal.cassandra.auth.RoleOptions;
import com.github.cassandra.jdbc.internal.cassandra.auth.RoleResource;
import com.github.cassandra.jdbc.internal.cassandra.config.DatabaseDescriptor;
import com.github.cassandra.jdbc.internal.cassandra.cql3.RoleName;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.AuthenticationStatement;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.InvalidRequestException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.RequestExecutionException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.RequestValidationException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.UnauthorizedException;
import com.github.cassandra.jdbc.internal.cassandra.service.ClientState;
import com.github.cassandra.jdbc.internal.cassandra.transport.messages.ResultMessage;

public class CreateRoleStatement
extends AuthenticationStatement {
    private final RoleResource role;
    private final RoleOptions opts;
    private final boolean ifNotExists;

    public CreateRoleStatement(RoleName name, RoleOptions options, boolean ifNotExists) {
        this.role = RoleResource.role(name.getName());
        this.opts = options;
        this.ifNotExists = ifNotExists;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException {
        super.checkPermission(state, Permission.CREATE, RoleResource.root());
        if (this.opts.getSuperuser().isPresent() && this.opts.getSuperuser().get().booleanValue() && !state.getUser().isSuper()) {
            throw new UnauthorizedException("Only superusers can create a role with superuser status");
        }
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        this.opts.validate();
        if (this.role.getRoleName().isEmpty()) {
            throw new InvalidRequestException("Role name can't be an empty string");
        }
        state.ensureNotAnonymous();
        if (!this.ifNotExists && DatabaseDescriptor.getRoleManager().isExistingRole(this.role)) {
            throw new InvalidRequestException(String.format("%s already exists", this.role.getRoleName()));
        }
    }

    @Override
    public ResultMessage execute(ClientState state) throws RequestExecutionException, RequestValidationException {
        if (this.ifNotExists && DatabaseDescriptor.getRoleManager().isExistingRole(this.role)) {
            return null;
        }
        DatabaseDescriptor.getRoleManager().createRole(state.getUser(), this.role, this.opts);
        this.grantPermissionsToCreator(state);
        return null;
    }

    private void grantPermissionsToCreator(ClientState state) {
        if (!state.getUser().isAnonymous()) {
            try {
                DatabaseDescriptor.getAuthorizer().grant(AuthenticatedUser.SYSTEM_USER, this.role.applicablePermissions(), this.role, RoleResource.role(state.getUser().getName()));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }
}

