/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.statements;

import com.github.cassandra.jdbc.internal.cassandra.auth.AuthenticatedUser;
import com.github.cassandra.jdbc.internal.cassandra.auth.DataResource;
import com.github.cassandra.jdbc.internal.cassandra.auth.FunctionResource;
import com.github.cassandra.jdbc.internal.cassandra.auth.Permission;
import com.github.cassandra.jdbc.internal.cassandra.auth.RoleResource;
import com.github.cassandra.jdbc.internal.cassandra.config.DatabaseDescriptor;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.KeyspaceAttributes;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.SchemaAlteringStatement;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.AlreadyExistsException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.ConfigurationException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.InvalidRequestException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.RequestExecutionException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.RequestValidationException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.UnauthorizedException;
import com.github.cassandra.jdbc.internal.cassandra.locator.LocalStrategy;
import com.github.cassandra.jdbc.internal.cassandra.schema.KeyspaceMetadata;
import com.github.cassandra.jdbc.internal.cassandra.schema.KeyspaceParams;
import com.github.cassandra.jdbc.internal.cassandra.service.ClientState;
import com.github.cassandra.jdbc.internal.cassandra.service.MigrationManager;
import com.github.cassandra.jdbc.internal.cassandra.service.QueryState;
import com.github.cassandra.jdbc.internal.cassandra.thrift.ThriftValidation;
import com.github.cassandra.jdbc.internal.cassandra.transport.Event;
import java.util.regex.Pattern;

public class CreateKeyspaceStatement
extends SchemaAlteringStatement {
    private static final Pattern PATTERN_WORD_CHARS = Pattern.compile("\\w+");
    private final String name;
    private final KeyspaceAttributes attrs;
    private final boolean ifNotExists;

    public CreateKeyspaceStatement(String name, KeyspaceAttributes attrs, boolean ifNotExists) {
        this.name = name;
        this.attrs = attrs;
        this.ifNotExists = ifNotExists;
    }

    @Override
    public String keyspace() {
        return this.name;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException {
        state.hasAllKeyspacesAccess(Permission.CREATE);
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        ThriftValidation.validateKeyspaceNotSystem((String)this.name);
        if (!PATTERN_WORD_CHARS.matcher(this.name).matches()) {
            throw new InvalidRequestException(String.format("\"%s\" is not a valid keyspace name", this.name));
        }
        if (this.name.length() > 48) {
            throw new InvalidRequestException(String.format("Keyspace names shouldn't be more than %s characters long (got \"%s\")", 48, this.name));
        }
        this.attrs.validate();
        if (this.attrs.getReplicationStrategyClass() == null) {
            throw new ConfigurationException("Missing mandatory replication strategy class");
        }
        KeyspaceParams params = this.attrs.asNewKeyspaceParams();
        params.validate(this.name);
        if (params.replication.klass.equals(LocalStrategy.class)) {
            throw new ConfigurationException("Unable to use given strategy class: LocalStrategy is reserved for internal use.");
        }
    }

    @Override
    public Event.SchemaChange announceMigration(boolean isLocalOnly) throws RequestValidationException {
        KeyspaceMetadata ksm = KeyspaceMetadata.create((String)this.name, (KeyspaceParams)this.attrs.asNewKeyspaceParams());
        try {
            MigrationManager.announceNewKeyspace((KeyspaceMetadata)ksm, (boolean)isLocalOnly);
            return new Event.SchemaChange(Event.SchemaChange.Change.CREATED, this.keyspace());
        }
        catch (AlreadyExistsException e) {
            if (this.ifNotExists) {
                return null;
            }
            throw e;
        }
    }

    @Override
    protected void grantPermissionsToCreator(QueryState state) {
        try {
            RoleResource role = RoleResource.role(state.getClientState().getUser().getName());
            DataResource keyspace = DataResource.keyspace(this.keyspace());
            DatabaseDescriptor.getAuthorizer().grant(AuthenticatedUser.SYSTEM_USER, keyspace.applicablePermissions(), keyspace, role);
            FunctionResource functions = FunctionResource.keyspace(this.keyspace());
            DatabaseDescriptor.getAuthorizer().grant(AuthenticatedUser.SYSTEM_USER, functions.applicablePermissions(), functions, role);
        }
        catch (RequestExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

