/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.statements;

import com.github.cassandra.jdbc.internal.cassandra.auth.Permission;
import com.github.cassandra.jdbc.internal.cassandra.config.CFMetaData;
import com.github.cassandra.jdbc.internal.cassandra.config.ColumnDefinition;
import com.github.cassandra.jdbc.internal.cassandra.config.Schema;
import com.github.cassandra.jdbc.internal.cassandra.cql3.CFName;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnIdentifier;
import com.github.cassandra.jdbc.internal.cassandra.cql3.IndexName;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.IndexPropDefs;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.IndexTarget;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.SchemaAlteringStatement;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.MapType;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.InvalidRequestException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.RequestValidationException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.UnauthorizedException;
import com.github.cassandra.jdbc.internal.cassandra.schema.IndexMetadata;
import com.github.cassandra.jdbc.internal.cassandra.schema.Indexes;
import com.github.cassandra.jdbc.internal.cassandra.service.ClientState;
import com.github.cassandra.jdbc.internal.cassandra.service.MigrationManager;
import com.github.cassandra.jdbc.internal.cassandra.thrift.ThriftValidation;
import com.github.cassandra.jdbc.internal.cassandra.transport.Event;
import com.github.cassandra.jdbc.internal.google.common.base.Optional;
import com.github.cassandra.jdbc.internal.google.common.base.Strings;
import com.github.cassandra.jdbc.internal.google.common.collect.Iterables;
import com.github.cassandra.jdbc.internal.slf4j.Logger;
import com.github.cassandra.jdbc.internal.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CreateIndexStatement
extends SchemaAlteringStatement {
    private static final Logger logger = LoggerFactory.getLogger(CreateIndexStatement.class);
    private final String indexName;
    private final List<IndexTarget.Raw> rawTargets;
    private final IndexPropDefs properties;
    private final boolean ifNotExists;

    public CreateIndexStatement(CFName name, IndexName indexName, List<IndexTarget.Raw> targets, IndexPropDefs properties, boolean ifNotExists) {
        super(name);
        this.indexName = indexName.getIdx();
        this.rawTargets = targets;
        this.properties = properties;
        this.ifNotExists = ifNotExists;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.ALTER);
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        CFMetaData cfm = ThriftValidation.validateColumnFamily((String)this.keyspace(), (String)this.columnFamily());
        if (cfm.isCounter()) {
            throw new InvalidRequestException("Secondary indexes are not supported on counter tables");
        }
        if (cfm.isView()) {
            throw new InvalidRequestException("Secondary indexes are not supported on materialized views");
        }
        if (cfm.isCompactTable() && !cfm.isStaticCompactTable()) {
            throw new InvalidRequestException("Secondary indexes are not supported on COMPACT STORAGE tables that have clustering columns");
        }
        ArrayList<IndexTarget> targets = new ArrayList<IndexTarget>(this.rawTargets.size());
        for (IndexTarget.Raw rawTarget : this.rawTargets) {
            targets.add(rawTarget.prepare(cfm));
        }
        if (targets.isEmpty() && !this.properties.isCustom) {
            throw new InvalidRequestException("Only CUSTOM indexes can be created without specifying a target column");
        }
        if (targets.size() > 1) {
            this.validateTargetsForMultiColumnIndex(targets);
        }
        for (IndexTarget target : targets) {
            boolean isFrozenCollection;
            ColumnDefinition cd = cfm.getColumnDefinition(target.column);
            if (cd == null) {
                throw new InvalidRequestException("No column definition found for column " + target.column);
            }
            if (cfm.isCompactTable() && cd.isPrimaryKeyColumn()) {
                throw new InvalidRequestException("Secondary indexes are not supported on PRIMARY KEY columns in COMPACT STORAGE tables");
            }
            if (cd.kind == ColumnDefinition.Kind.PARTITION_KEY && cfm.getKeyValidatorAsClusteringComparator().size() == 1) {
                throw new InvalidRequestException(String.format("Cannot create secondary index on partition key column %s", target.column));
            }
            boolean isMap = cd.type instanceof MapType;
            boolean bl = isFrozenCollection = cd.type.isCollection() && !cd.type.isMultiCell();
            if (isFrozenCollection) {
                this.validateForFrozenCollection(target);
                continue;
            }
            this.validateNotFullIndex(target);
            this.validateIsSimpleIndexIfTargetColumnNotCollection(cd, target);
            this.validateTargetColumnIsMapIfIndexInvolvesKeys(isMap, target);
        }
        if (!Strings.isNullOrEmpty(this.indexName) && Schema.instance.getKSMetaData(this.keyspace()).existingIndexNames(null).contains(this.indexName)) {
            if (this.ifNotExists) {
                return;
            }
            throw new InvalidRequestException(String.format("Index %s already exists", this.indexName));
        }
        this.properties.validate();
    }

    private void validateForFrozenCollection(IndexTarget target) throws InvalidRequestException {
        if (target.type != IndexTarget.Type.FULL) {
            throw new InvalidRequestException(String.format("Cannot create %s() index on frozen column %s. Frozen collections only support full() indexes", new Object[]{target.type, target.column}));
        }
    }

    private void validateNotFullIndex(IndexTarget target) throws InvalidRequestException {
        if (target.type == IndexTarget.Type.FULL) {
            throw new InvalidRequestException("full() indexes can only be created on frozen collections");
        }
    }

    private void validateIsSimpleIndexIfTargetColumnNotCollection(ColumnDefinition cd, IndexTarget target) throws InvalidRequestException {
        if (!cd.type.isCollection() && target.type != IndexTarget.Type.SIMPLE) {
            throw new InvalidRequestException(String.format("Cannot create %s() index on %s. Non-collection columns support only simple indexes", target.type.toString(), target.column));
        }
    }

    private void validateTargetColumnIsMapIfIndexInvolvesKeys(boolean isMap, IndexTarget target) throws InvalidRequestException {
        if (!(target.type != IndexTarget.Type.KEYS && target.type != IndexTarget.Type.KEYS_AND_VALUES || isMap)) {
            throw new InvalidRequestException(String.format("Cannot create index on %s of column %s with non-map type", new Object[]{target.type, target.column}));
        }
    }

    private void validateTargetsForMultiColumnIndex(List<IndexTarget> targets) {
        if (!this.properties.isCustom) {
            throw new InvalidRequestException("Only CUSTOM indexes support multiple columns");
        }
        HashSet<ColumnIdentifier> columns = new HashSet<ColumnIdentifier>();
        for (IndexTarget target : targets) {
            if (columns.add(target.column)) continue;
            throw new InvalidRequestException("Duplicate column " + target.column + " in index target list");
        }
    }

    @Override
    public Event.SchemaChange announceMigration(boolean isLocalOnly) throws RequestValidationException {
        Map<Object, Object> indexOptions;
        IndexMetadata.Kind kind;
        CFMetaData cfm = Schema.instance.getCFMetaData(this.keyspace(), this.columnFamily()).copy();
        ArrayList<IndexTarget> targets = new ArrayList<IndexTarget>(this.rawTargets.size());
        for (IndexTarget.Raw rawTarget : this.rawTargets) {
            targets.add(rawTarget.prepare(cfm));
        }
        String acceptedName = this.indexName;
        if (Strings.isNullOrEmpty(acceptedName)) {
            acceptedName = Indexes.getAvailableIndexName((String)this.keyspace(), (String)this.columnFamily(), targets.size() == 1 ? ((IndexTarget)targets.get((int)0)).column.toString() : null);
        }
        if (Schema.instance.getKSMetaData(this.keyspace()).existingIndexNames(null).contains(acceptedName)) {
            if (this.ifNotExists) {
                return null;
            }
            throw new InvalidRequestException(String.format("Index %s already exists", acceptedName));
        }
        if (this.properties.isCustom) {
            kind = IndexMetadata.Kind.CUSTOM;
            indexOptions = this.properties.getOptions();
        } else {
            indexOptions = Collections.emptyMap();
            kind = cfm.isCompound() ? IndexMetadata.Kind.COMPOSITES : IndexMetadata.Kind.KEYS;
        }
        IndexMetadata index = IndexMetadata.fromIndexTargets((CFMetaData)cfm, targets, (String)acceptedName, (IndexMetadata.Kind)kind, indexOptions);
        Optional existingIndex = Iterables.tryFind(cfm.getIndexes(), existing -> existing.equalsWithoutName(index));
        if (existingIndex.isPresent()) {
            if (this.ifNotExists) {
                return null;
            }
            throw new InvalidRequestException(String.format("Index %s is a duplicate of existing index %s", index.name, ((IndexMetadata)existingIndex.get()).name));
        }
        logger.trace("Updating index definition for {}", (Object)this.indexName);
        cfm.indexes(cfm.getIndexes().with(index));
        MigrationManager.announceColumnFamilyUpdate((CFMetaData)cfm, (boolean)false, (boolean)isLocalOnly);
        return new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, Event.SchemaChange.Target.TABLE, this.keyspace(), this.columnFamily());
    }
}

