/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.statements;

import com.github.cassandra.jdbc.internal.cassandra.auth.AuthenticatedUser;
import com.github.cassandra.jdbc.internal.cassandra.auth.FunctionResource;
import com.github.cassandra.jdbc.internal.cassandra.auth.IResource;
import com.github.cassandra.jdbc.internal.cassandra.auth.Permission;
import com.github.cassandra.jdbc.internal.cassandra.auth.RoleResource;
import com.github.cassandra.jdbc.internal.cassandra.config.DatabaseDescriptor;
import com.github.cassandra.jdbc.internal.cassandra.config.Schema;
import com.github.cassandra.jdbc.internal.cassandra.cql3.CQL3Type;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnIdentifier;
import com.github.cassandra.jdbc.internal.cassandra.cql3.functions.Function;
import com.github.cassandra.jdbc.internal.cassandra.cql3.functions.FunctionName;
import com.github.cassandra.jdbc.internal.cassandra.cql3.functions.ScalarFunction;
import com.github.cassandra.jdbc.internal.cassandra.cql3.functions.UDFunction;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.ParsedStatement;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.SchemaAlteringStatement;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.AbstractType;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.InvalidRequestException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.RequestExecutionException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.RequestValidationException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.UnauthorizedException;
import com.github.cassandra.jdbc.internal.cassandra.schema.Functions;
import com.github.cassandra.jdbc.internal.cassandra.service.ClientState;
import com.github.cassandra.jdbc.internal.cassandra.service.MigrationManager;
import com.github.cassandra.jdbc.internal.cassandra.service.QueryState;
import com.github.cassandra.jdbc.internal.cassandra.thrift.ThriftValidation;
import com.github.cassandra.jdbc.internal.cassandra.transport.Event;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class CreateFunctionStatement
extends SchemaAlteringStatement {
    private final boolean orReplace;
    private final boolean ifNotExists;
    private FunctionName functionName;
    private final String language;
    private final String body;
    private final List<ColumnIdentifier> argNames;
    private final List<CQL3Type.Raw> argRawTypes;
    private final CQL3Type.Raw rawReturnType;
    private final boolean calledOnNullInput;
    private List<AbstractType<?>> argTypes;
    private AbstractType<?> returnType;

    public CreateFunctionStatement(FunctionName functionName, String language, String body, List<ColumnIdentifier> argNames, List<CQL3Type.Raw> argRawTypes, CQL3Type.Raw rawReturnType, boolean calledOnNullInput, boolean orReplace, boolean ifNotExists) {
        this.functionName = functionName;
        this.language = language;
        this.body = body;
        this.argNames = argNames;
        this.argRawTypes = argRawTypes;
        this.rawReturnType = rawReturnType;
        this.calledOnNullInput = calledOnNullInput;
        this.orReplace = orReplace;
        this.ifNotExists = ifNotExists;
    }

    @Override
    public ParsedStatement.Prepared prepare() throws InvalidRequestException {
        if (new HashSet<ColumnIdentifier>(this.argNames).size() != this.argNames.size()) {
            throw new InvalidRequestException(String.format("duplicate argument names for given function %s with argument names %s", this.functionName, this.argNames));
        }
        this.argTypes = new ArrayList(this.argRawTypes.size());
        for (CQL3Type.Raw rawType : this.argRawTypes) {
            this.argTypes.add(this.prepareType("arguments", rawType));
        }
        this.returnType = this.prepareType("return type", this.rawReturnType);
        return super.prepare();
    }

    @Override
    public void prepareKeyspace(ClientState state) throws InvalidRequestException {
        if (!this.functionName.hasKeyspace() && state.getRawKeyspace() != null) {
            this.functionName = new FunctionName(state.getRawKeyspace(), this.functionName.name);
        }
        if (!this.functionName.hasKeyspace()) {
            throw new InvalidRequestException("Functions must be fully qualified with a keyspace name if a keyspace is not set for the session");
        }
        ThriftValidation.validateKeyspaceNotSystem((String)this.functionName.keyspace);
    }

    @Override
    protected void grantPermissionsToCreator(QueryState state) {
        try {
            FunctionResource resource = FunctionResource.function(this.functionName.keyspace, this.functionName.name, this.argTypes);
            DatabaseDescriptor.getAuthorizer().grant(AuthenticatedUser.SYSTEM_USER, resource.applicablePermissions(), resource, RoleResource.role(state.getClientState().getUser().getName()));
        }
        catch (RequestExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        if (Schema.instance.findFunction(this.functionName, this.argTypes).isPresent() && this.orReplace) {
            state.ensureHasPermission(Permission.ALTER, (IResource)FunctionResource.function(this.functionName.keyspace, this.functionName.name, this.argTypes));
        } else {
            state.ensureHasPermission(Permission.CREATE, (IResource)FunctionResource.keyspace(this.functionName.keyspace));
        }
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
        UDFunction.assertUdfsEnabled(this.language);
        if (this.ifNotExists && this.orReplace) {
            throw new InvalidRequestException("Cannot use both 'OR REPLACE' and 'IF NOT EXISTS' directives");
        }
        if (Schema.instance.getKSMetaData(this.functionName.keyspace) == null) {
            throw new InvalidRequestException(String.format("Cannot add function '%s' to non existing keyspace '%s'.", this.functionName.name, this.functionName.keyspace));
        }
    }

    @Override
    public Event.SchemaChange announceMigration(boolean isLocalOnly) throws RequestValidationException {
        boolean replaced;
        Function old = Schema.instance.findFunction(this.functionName, this.argTypes).orElse(null);
        boolean bl = replaced = old != null;
        if (replaced) {
            if (this.ifNotExists) {
                return null;
            }
            if (!this.orReplace) {
                throw new InvalidRequestException(String.format("Function %s already exists", old));
            }
            if (!(old instanceof ScalarFunction)) {
                throw new InvalidRequestException(String.format("Function %s can only replace a function", old));
            }
            if (this.calledOnNullInput != ((ScalarFunction)old).isCalledOnNullInput()) {
                throw new InvalidRequestException(String.format("Function %s can only be replaced with %s", old, this.calledOnNullInput ? "CALLED ON NULL INPUT" : "RETURNS NULL ON NULL INPUT"));
            }
            if (!Functions.typesMatch(old.returnType(), this.returnType)) {
                throw new InvalidRequestException(String.format("Cannot replace function %s, the new return type %s is not compatible with the return type %s of existing function", this.functionName, this.returnType.asCQL3Type(), old.returnType().asCQL3Type()));
            }
        }
        UDFunction udFunction = UDFunction.create(this.functionName, this.argNames, this.argTypes, this.returnType, this.calledOnNullInput, this.language, this.body);
        MigrationManager.announceNewFunction((UDFunction)udFunction, (boolean)isLocalOnly);
        return new Event.SchemaChange(replaced ? Event.SchemaChange.Change.UPDATED : Event.SchemaChange.Change.CREATED, Event.SchemaChange.Target.FUNCTION, udFunction.name().keyspace, udFunction.name().name, AbstractType.asCQLTypeStringList(udFunction.argTypes()));
    }

    private AbstractType<?> prepareType(String typeName, CQL3Type.Raw rawType) {
        if (rawType.isFrozen()) {
            throw new InvalidRequestException(String.format("The function %s should not be frozen; remove the frozen<> modifier", typeName));
        }
        if (!rawType.canBeNonFrozen()) {
            rawType.freeze();
        }
        AbstractType<?> type = rawType.prepare(this.functionName.keyspace).getType();
        return type;
    }
}

