/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.statements;

import com.github.cassandra.jdbc.internal.cassandra.auth.AuthenticatedUser;
import com.github.cassandra.jdbc.internal.cassandra.auth.FunctionResource;
import com.github.cassandra.jdbc.internal.cassandra.auth.IResource;
import com.github.cassandra.jdbc.internal.cassandra.auth.Permission;
import com.github.cassandra.jdbc.internal.cassandra.auth.RoleResource;
import com.github.cassandra.jdbc.internal.cassandra.config.DatabaseDescriptor;
import com.github.cassandra.jdbc.internal.cassandra.config.Schema;
import com.github.cassandra.jdbc.internal.cassandra.cql3.CQL3Type;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Constants;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Term;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Terms;
import com.github.cassandra.jdbc.internal.cassandra.cql3.functions.AggregateFunction;
import com.github.cassandra.jdbc.internal.cassandra.cql3.functions.Function;
import com.github.cassandra.jdbc.internal.cassandra.cql3.functions.FunctionName;
import com.github.cassandra.jdbc.internal.cassandra.cql3.functions.ScalarFunction;
import com.github.cassandra.jdbc.internal.cassandra.cql3.functions.UDAggregate;
import com.github.cassandra.jdbc.internal.cassandra.cql3.functions.UDHelper;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.ParsedStatement;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.SchemaAlteringStatement;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.AbstractType;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.InvalidRequestException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.RequestExecutionException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.RequestValidationException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.UnauthorizedException;
import com.github.cassandra.jdbc.internal.cassandra.serializers.MarshalException;
import com.github.cassandra.jdbc.internal.cassandra.service.ClientState;
import com.github.cassandra.jdbc.internal.cassandra.service.MigrationManager;
import com.github.cassandra.jdbc.internal.cassandra.service.QueryState;
import com.github.cassandra.jdbc.internal.cassandra.thrift.ThriftValidation;
import com.github.cassandra.jdbc.internal.cassandra.transport.Event;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class CreateAggregateStatement
extends SchemaAlteringStatement {
    private final boolean orReplace;
    private final boolean ifNotExists;
    private FunctionName functionName;
    private FunctionName stateFunc;
    private FunctionName finalFunc;
    private final CQL3Type.Raw stateTypeRaw;
    private final List<CQL3Type.Raw> argRawTypes;
    private final Term.Raw ival;
    private List<AbstractType<?>> argTypes;
    private AbstractType<?> returnType;
    private ScalarFunction stateFunction;
    private ScalarFunction finalFunction;
    private ByteBuffer initcond;

    public CreateAggregateStatement(FunctionName functionName, List<CQL3Type.Raw> argRawTypes, String stateFunc, CQL3Type.Raw stateType, String finalFunc, Term.Raw ival, boolean orReplace, boolean ifNotExists) {
        this.functionName = functionName;
        this.argRawTypes = argRawTypes;
        this.stateFunc = new FunctionName(functionName.keyspace, stateFunc);
        this.finalFunc = finalFunc != null ? new FunctionName(functionName.keyspace, finalFunc) : null;
        this.stateTypeRaw = stateType;
        this.ival = ival;
        this.orReplace = orReplace;
        this.ifNotExists = ifNotExists;
    }

    @Override
    public ParsedStatement.Prepared prepare() {
        this.argTypes = new ArrayList(this.argRawTypes.size());
        for (CQL3Type.Raw rawType : this.argRawTypes) {
            this.argTypes.add(this.prepareType("arguments", rawType));
        }
        AbstractType<?> stateType = this.prepareType("state type", this.stateTypeRaw);
        List<AbstractType<?>> stateArgs = CreateAggregateStatement.stateArguments(stateType, this.argTypes);
        Function f = Schema.instance.findFunction(this.stateFunc, stateArgs).orElse(null);
        if (!(f instanceof ScalarFunction)) {
            throw new InvalidRequestException("State function " + CreateAggregateStatement.stateFuncSig(this.stateFunc, this.stateTypeRaw, this.argRawTypes) + " does not exist or is not a scalar function");
        }
        this.stateFunction = (ScalarFunction)f;
        AbstractType<?> stateReturnType = this.stateFunction.returnType();
        if (!stateReturnType.equals(stateType)) {
            throw new InvalidRequestException("State function " + CreateAggregateStatement.stateFuncSig(this.stateFunction.name(), this.stateTypeRaw, this.argRawTypes) + " return type must be the same as the first argument type - check STYPE, argument and return types");
        }
        if (this.finalFunc != null) {
            List<AbstractType<?>> finalArgs = Collections.singletonList(stateType);
            f = Schema.instance.findFunction(this.finalFunc, finalArgs).orElse(null);
            if (!(f instanceof ScalarFunction)) {
                throw new InvalidRequestException("Final function " + this.finalFunc + '(' + this.stateTypeRaw + ") does not exist or is not a scalar function");
            }
            this.finalFunction = (ScalarFunction)f;
            this.returnType = this.finalFunction.returnType();
        } else {
            this.returnType = stateReturnType;
        }
        if (this.ival != null) {
            this.initcond = Terms.asBytes(this.functionName.keyspace, this.ival.toString(), stateType);
            if (this.initcond != null) {
                try {
                    stateType.validate(this.initcond);
                }
                catch (MarshalException e) {
                    throw new InvalidRequestException(String.format("Invalid value for INITCOND of type %s%s", stateType.asCQL3Type(), e.getMessage() == null ? "" : String.format(" (%s)", e.getMessage())));
                }
            }
            String initcondAsCql = stateType.asCQL3Type().toCQLLiteral(this.initcond, 4);
            assert (Objects.equals(this.initcond, Terms.asBytes(this.functionName.keyspace, initcondAsCql, stateType)));
            if (Constants.NULL_LITERAL != this.ival && UDHelper.isNullOrEmpty(stateType, this.initcond)) {
                throw new InvalidRequestException("INITCOND must not be empty for all types except TEXT, ASCII, BLOB");
            }
        }
        return super.prepare();
    }

    private AbstractType<?> prepareType(String typeName, CQL3Type.Raw rawType) {
        if (rawType.isFrozen()) {
            throw new InvalidRequestException(String.format("The function %s should not be frozen; remove the frozen<> modifier", typeName));
        }
        if (!rawType.canBeNonFrozen()) {
            rawType.freeze();
        }
        AbstractType<?> type = rawType.prepare(this.functionName.keyspace).getType();
        return type;
    }

    @Override
    public void prepareKeyspace(ClientState state) throws InvalidRequestException {
        if (!this.functionName.hasKeyspace() && state.getRawKeyspace() != null) {
            this.functionName = new FunctionName(state.getKeyspace(), this.functionName.name);
        }
        if (!this.functionName.hasKeyspace()) {
            throw new InvalidRequestException("Functions must be fully qualified with a keyspace name if a keyspace is not set for the session");
        }
        ThriftValidation.validateKeyspaceNotSystem((String)this.functionName.keyspace);
        this.stateFunc = new FunctionName(this.functionName.keyspace, this.stateFunc.name);
        if (this.finalFunc != null) {
            this.finalFunc = new FunctionName(this.functionName.keyspace, this.finalFunc.name);
        }
    }

    @Override
    protected void grantPermissionsToCreator(QueryState state) {
        try {
            FunctionResource resource = FunctionResource.function(this.functionName.keyspace, this.functionName.name, this.argTypes);
            DatabaseDescriptor.getAuthorizer().grant(AuthenticatedUser.SYSTEM_USER, resource.applicablePermissions(), resource, RoleResource.role(state.getClientState().getUser().getName()));
        }
        catch (RequestExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        if (Schema.instance.findFunction(this.functionName, this.argTypes).isPresent() && this.orReplace) {
            state.ensureHasPermission(Permission.ALTER, (IResource)FunctionResource.function(this.functionName.keyspace, this.functionName.name, this.argTypes));
        } else {
            state.ensureHasPermission(Permission.CREATE, (IResource)FunctionResource.keyspace(this.functionName.keyspace));
        }
        for (Function referencedFunction : this.stateFunction.getFunctions()) {
            state.ensureHasPermission(Permission.EXECUTE, referencedFunction);
        }
        if (this.finalFunction != null) {
            for (Function referencedFunction : this.finalFunction.getFunctions()) {
                state.ensureHasPermission(Permission.EXECUTE, referencedFunction);
            }
        }
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
        if (this.ifNotExists && this.orReplace) {
            throw new InvalidRequestException("Cannot use both 'OR REPLACE' and 'IF NOT EXISTS' directives");
        }
        if (Schema.instance.getKSMetaData(this.functionName.keyspace) == null) {
            throw new InvalidRequestException(String.format("Cannot add aggregate '%s' to non existing keyspace '%s'.", this.functionName.name, this.functionName.keyspace));
        }
    }

    @Override
    public Event.SchemaChange announceMigration(boolean isLocalOnly) throws RequestValidationException {
        boolean replaced;
        Function old = Schema.instance.findFunction(this.functionName, this.argTypes).orElse(null);
        boolean bl = replaced = old != null;
        if (replaced) {
            if (this.ifNotExists) {
                return null;
            }
            if (!this.orReplace) {
                throw new InvalidRequestException(String.format("Function %s already exists", old));
            }
            if (!(old instanceof AggregateFunction)) {
                throw new InvalidRequestException(String.format("Aggregate %s can only replace an aggregate", old));
            }
            if (old.isNative()) {
                throw new InvalidRequestException(String.format("Cannot replace native aggregate %s", old));
            }
            if (!old.returnType().isValueCompatibleWith(this.returnType)) {
                throw new InvalidRequestException(String.format("Cannot replace aggregate %s, the new return type %s is not compatible with the return type %s of existing function", this.functionName, this.returnType.asCQL3Type(), old.returnType().asCQL3Type()));
            }
        }
        if (!this.stateFunction.isCalledOnNullInput() && this.initcond == null) {
            throw new InvalidRequestException(String.format("Cannot create aggregate %s without INITCOND because state function %s does not accept 'null' arguments", this.functionName, this.stateFunc));
        }
        UDAggregate udAggregate = new UDAggregate(this.functionName, this.argTypes, this.returnType, this.stateFunction, this.finalFunction, this.initcond);
        MigrationManager.announceNewAggregate((UDAggregate)udAggregate, (boolean)isLocalOnly);
        return new Event.SchemaChange(replaced ? Event.SchemaChange.Change.UPDATED : Event.SchemaChange.Change.CREATED, Event.SchemaChange.Target.AGGREGATE, udAggregate.name().keyspace, udAggregate.name().name, AbstractType.asCQLTypeStringList(udAggregate.argTypes()));
    }

    private static String stateFuncSig(FunctionName stateFuncName, CQL3Type.Raw stateTypeRaw, List<CQL3Type.Raw> argRawTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append(stateFuncName.toString()).append('(').append(stateTypeRaw);
        for (CQL3Type.Raw argRawType : argRawTypes) {
            sb.append(", ").append(argRawType);
        }
        sb.append(')');
        return sb.toString();
    }

    private static List<AbstractType<?>> stateArguments(AbstractType<?> stateType, List<AbstractType<?>> argTypes) {
        ArrayList r = new ArrayList(argTypes.size() + 1);
        r.add(stateType);
        r.addAll(argTypes);
        return r;
    }
}

