/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.statements;

import com.github.cassandra.jdbc.internal.cassandra.config.CFMetaData;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnCondition;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnIdentifier;
import com.github.cassandra.jdbc.internal.cassandra.cql3.QueryOptions;
import com.github.cassandra.jdbc.internal.cassandra.cql3.UpdateParameters;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.BatchStatement;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.ModificationStatement;
import com.github.cassandra.jdbc.internal.cassandra.db.Clustering;
import com.github.cassandra.jdbc.internal.cassandra.db.Columns;
import com.github.cassandra.jdbc.internal.cassandra.db.DecoratedKey;
import com.github.cassandra.jdbc.internal.cassandra.db.Keyspace;
import com.github.cassandra.jdbc.internal.cassandra.db.PartitionColumns;
import com.github.cassandra.jdbc.internal.cassandra.db.SinglePartitionReadCommand;
import com.github.cassandra.jdbc.internal.cassandra.db.Slice;
import com.github.cassandra.jdbc.internal.cassandra.db.Slices;
import com.github.cassandra.jdbc.internal.cassandra.db.filter.ClusteringIndexFilter;
import com.github.cassandra.jdbc.internal.cassandra.db.filter.ClusteringIndexSliceFilter;
import com.github.cassandra.jdbc.internal.cassandra.db.filter.ColumnFilter;
import com.github.cassandra.jdbc.internal.cassandra.db.partitions.FilteredPartition;
import com.github.cassandra.jdbc.internal.cassandra.db.partitions.PartitionUpdate;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.InvalidRequestException;
import com.github.cassandra.jdbc.internal.cassandra.service.CASRequest;
import com.github.cassandra.jdbc.internal.cassandra.utils.Pair;
import com.github.cassandra.jdbc.internal.google.common.collect.HashMultimap;
import com.github.cassandra.jdbc.internal.google.common.collect.Multimap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class CQL3CasRequest
implements CASRequest {
    public final CFMetaData cfm;
    public final DecoratedKey key;
    public final boolean isBatch;
    private final PartitionColumns conditionColumns;
    private final boolean updatesRegularRows;
    private final boolean updatesStaticRow;
    private boolean hasExists;
    private final SortedMap<Clustering, RowCondition> conditions;
    private final List<RowUpdate> updates = new ArrayList<RowUpdate>();

    public CQL3CasRequest(CFMetaData cfm, DecoratedKey key, boolean isBatch, PartitionColumns conditionColumns, boolean updatesRegularRows, boolean updatesStaticRow) {
        this.cfm = cfm;
        this.key = key;
        this.conditions = new TreeMap<Clustering, RowCondition>((Comparator<Clustering>)cfm.comparator);
        this.isBatch = isBatch;
        this.conditionColumns = conditionColumns;
        this.updatesRegularRows = updatesRegularRows;
        this.updatesStaticRow = updatesStaticRow;
    }

    public void addRowUpdate(Clustering clustering, ModificationStatement stmt, QueryOptions options, long timestamp) {
        this.updates.add(new RowUpdate(clustering, stmt, options, timestamp));
    }

    public void addNotExist(Clustering clustering) throws InvalidRequestException {
        RowCondition previous = this.conditions.put(clustering, new NotExistCondition(clustering));
        if (previous != null && !(previous instanceof NotExistCondition)) {
            if (previous instanceof ExistCondition) {
                throw new InvalidRequestException("Cannot mix IF EXISTS and IF NOT EXISTS conditions for the same row");
            }
            throw new InvalidRequestException("Cannot mix IF conditions and IF NOT EXISTS for the same row");
        }
        this.hasExists = true;
    }

    public void addExist(Clustering clustering) throws InvalidRequestException {
        RowCondition previous = this.conditions.put(clustering, new ExistCondition(clustering));
        if (previous instanceof NotExistCondition) {
            throw new InvalidRequestException("Cannot mix IF EXISTS and IF NOT EXISTS conditions for the same row");
        }
        this.hasExists = true;
    }

    public void addConditions(Clustering clustering, Collection<ColumnCondition> conds, QueryOptions options) throws InvalidRequestException {
        RowCondition condition = (RowCondition)this.conditions.get(clustering);
        if (condition == null) {
            condition = new ColumnsConditions(clustering);
            this.conditions.put(clustering, condition);
        } else if (!(condition instanceof ColumnsConditions)) {
            throw new InvalidRequestException("Cannot mix IF conditions and IF NOT EXISTS for the same row");
        }
        ((ColumnsConditions)condition).addConditions(conds, options);
    }

    private PartitionColumns columnsToRead() {
        if (this.hasExists) {
            PartitionColumns allColumns = this.cfm.partitionColumns();
            Columns statics = this.updatesStaticRow ? allColumns.statics : Columns.NONE;
            Columns regulars = this.updatesRegularRows ? allColumns.regulars : Columns.NONE;
            return new PartitionColumns(statics, regulars);
        }
        return this.conditionColumns;
    }

    public SinglePartitionReadCommand readCommand(int nowInSec) {
        assert (!this.conditions.isEmpty());
        Slices.Builder builder = new Slices.Builder(this.cfm.comparator, this.conditions.size());
        for (Clustering clustering : this.conditions.keySet()) {
            if (clustering == Clustering.STATIC_CLUSTERING) continue;
            builder.add(Slice.make((Clustering)clustering));
        }
        ClusteringIndexSliceFilter filter = new ClusteringIndexSliceFilter(builder.build(), false);
        return SinglePartitionReadCommand.create((CFMetaData)this.cfm, (int)nowInSec, (DecoratedKey)this.key, (ColumnFilter)ColumnFilter.selection((PartitionColumns)this.columnsToRead()), (ClusteringIndexFilter)filter);
    }

    public boolean appliesTo(FilteredPartition current) throws InvalidRequestException {
        for (RowCondition condition : this.conditions.values()) {
            if (condition.appliesTo(current)) continue;
            return false;
        }
        return true;
    }

    private PartitionColumns updatedColumns() {
        PartitionColumns.Builder builder = PartitionColumns.builder();
        for (RowUpdate upd : this.updates) {
            builder.addAll(upd.stmt.updatedColumns());
        }
        return builder.build();
    }

    public PartitionUpdate makeUpdates(FilteredPartition current) throws InvalidRequestException {
        PartitionUpdate update = new PartitionUpdate(this.cfm, this.key, this.updatedColumns(), this.conditions.size());
        for (RowUpdate upd : this.updates) {
            upd.applyUpdates(current, update);
        }
        Keyspace.openAndGetStore((CFMetaData)this.cfm).indexManager.validate(update);
        if (this.isBatch) {
            BatchStatement.verifyBatchSize(Collections.singleton(update));
        }
        return update;
    }

    private static class ColumnsConditions
    extends RowCondition {
        private final Multimap<Pair<ColumnIdentifier, ByteBuffer>, ColumnCondition.Bound> conditions = HashMultimap.create();

        private ColumnsConditions(Clustering clustering) {
            super(clustering);
        }

        public void addConditions(Collection<ColumnCondition> conds, QueryOptions options) throws InvalidRequestException {
            for (ColumnCondition condition : conds) {
                ColumnCondition.Bound current = condition.bind(options);
                this.conditions.put(Pair.create(condition.column.name, current.getCollectionElementValue()), current);
            }
        }

        @Override
        public boolean appliesTo(FilteredPartition current) throws InvalidRequestException {
            if (current == null) {
                return this.conditions.isEmpty();
            }
            for (ColumnCondition.Bound condition : this.conditions.values()) {
                if (condition.appliesTo(current.getRow(this.clustering))) continue;
                return false;
            }
            return true;
        }
    }

    private static class ExistCondition
    extends RowCondition {
        private ExistCondition(Clustering clustering) {
            super(clustering);
        }

        @Override
        public boolean appliesTo(FilteredPartition current) {
            return current != null && current.getRow(this.clustering) != null;
        }
    }

    private static class NotExistCondition
    extends RowCondition {
        private NotExistCondition(Clustering clustering) {
            super(clustering);
        }

        @Override
        public boolean appliesTo(FilteredPartition current) {
            return current == null || current.getRow(this.clustering) == null;
        }
    }

    private static abstract class RowCondition {
        public final Clustering clustering;

        protected RowCondition(Clustering clustering) {
            this.clustering = clustering;
        }

        public abstract boolean appliesTo(FilteredPartition var1) throws InvalidRequestException;
    }

    private class RowUpdate {
        private final Clustering clustering;
        private final ModificationStatement stmt;
        private final QueryOptions options;
        private final long timestamp;

        private RowUpdate(Clustering clustering, ModificationStatement stmt, QueryOptions options, long timestamp) {
            this.clustering = clustering;
            this.stmt = stmt;
            this.options = options;
            this.timestamp = timestamp;
        }

        public void applyUpdates(FilteredPartition current, PartitionUpdate updates) throws InvalidRequestException {
            Map<DecoratedKey, FilteredPartition> map = this.stmt.requiresRead() ? Collections.singletonMap(CQL3CasRequest.this.key, current) : null;
            UpdateParameters params = new UpdateParameters(CQL3CasRequest.this.cfm, updates.columns(), this.options, this.timestamp, this.stmt.getTimeToLive(this.options), map);
            this.stmt.addUpdateForKey(updates, this.clustering, params);
        }
    }
}

