/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.statements;

import com.github.cassandra.jdbc.internal.cassandra.cql3.CFName;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.ParsedStatement;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.InvalidRequestException;
import com.github.cassandra.jdbc.internal.cassandra.service.ClientState;

public abstract class CFStatement
extends ParsedStatement {
    protected final CFName cfName;

    protected CFStatement(CFName cfName) {
        this.cfName = cfName;
    }

    public void prepareKeyspace(ClientState state) throws InvalidRequestException {
        if (!this.cfName.hasKeyspace()) {
            this.cfName.setKeyspace(state.getKeyspace(), true);
        }
    }

    public void prepareKeyspace(String keyspace) {
        if (!this.cfName.hasKeyspace()) {
            this.cfName.setKeyspace(keyspace, true);
        }
    }

    public String keyspace() {
        assert (this.cfName.hasKeyspace()) : "The statement hasn't be prepared correctly";
        return this.cfName.getKeyspace();
    }

    public String columnFamily() {
        return this.cfName.getColumnFamily();
    }
}

