/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.statements;

import com.github.cassandra.jdbc.internal.cassandra.auth.IResource;
import com.github.cassandra.jdbc.internal.cassandra.auth.Permission;
import com.github.cassandra.jdbc.internal.cassandra.auth.RoleResource;
import com.github.cassandra.jdbc.internal.cassandra.cql3.CQLStatement;
import com.github.cassandra.jdbc.internal.cassandra.cql3.QueryOptions;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.ParsedStatement;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.RequestExecutionException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.RequestValidationException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.UnauthorizedException;
import com.github.cassandra.jdbc.internal.cassandra.service.ClientState;
import com.github.cassandra.jdbc.internal.cassandra.service.QueryState;
import com.github.cassandra.jdbc.internal.cassandra.transport.messages.ResultMessage;

public abstract class AuthenticationStatement
extends ParsedStatement
implements CQLStatement {
    @Override
    public ParsedStatement.Prepared prepare() {
        return new ParsedStatement.Prepared(this);
    }

    @Override
    public int getBoundTerms() {
        return 0;
    }

    @Override
    public ResultMessage execute(QueryState state, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        return this.execute(state.getClientState());
    }

    public abstract ResultMessage execute(ClientState var1) throws RequestExecutionException, RequestValidationException;

    @Override
    public ResultMessage executeInternal(QueryState state, QueryOptions options) {
        throw new UnsupportedOperationException();
    }

    public void checkPermission(ClientState state, Permission required, RoleResource resource) throws UnauthorizedException {
        try {
            state.ensureHasPermission(required, (IResource)resource);
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException(String.format("User %s does not have sufficient privileges to perform the requested operation", state.getUser().getName()));
        }
    }
}

