/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.statements;

import com.github.cassandra.jdbc.internal.cassandra.auth.Permission;
import com.github.cassandra.jdbc.internal.cassandra.config.CFMetaData;
import com.github.cassandra.jdbc.internal.cassandra.config.Schema;
import com.github.cassandra.jdbc.internal.cassandra.config.ViewDefinition;
import com.github.cassandra.jdbc.internal.cassandra.cql3.CFName;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.SchemaAlteringStatement;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.TableAttributes;
import com.github.cassandra.jdbc.internal.cassandra.db.view.View;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.InvalidRequestException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.RequestValidationException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.UnauthorizedException;
import com.github.cassandra.jdbc.internal.cassandra.schema.TableParams;
import com.github.cassandra.jdbc.internal.cassandra.service.ClientState;
import com.github.cassandra.jdbc.internal.cassandra.service.MigrationManager;
import com.github.cassandra.jdbc.internal.cassandra.thrift.ThriftValidation;
import com.github.cassandra.jdbc.internal.cassandra.transport.Event;

public class AlterViewStatement
extends SchemaAlteringStatement {
    private final TableAttributes attrs;

    public AlterViewStatement(CFName name, TableAttributes attrs) {
        super(name);
        this.attrs = attrs;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        CFMetaData baseTable = View.findBaseTable((String)this.keyspace(), (String)this.columnFamily());
        if (baseTable != null) {
            state.hasColumnFamilyAccess(this.keyspace(), baseTable.cfName, Permission.ALTER);
        }
    }

    @Override
    public void validate(ClientState state) {
    }

    @Override
    public Event.SchemaChange announceMigration(boolean isLocalOnly) throws RequestValidationException {
        CFMetaData meta = ThriftValidation.validateColumnFamily((String)this.keyspace(), (String)this.columnFamily());
        if (!meta.isView()) {
            throw new InvalidRequestException("Cannot use ALTER MATERIALIZED VIEW on Table");
        }
        ViewDefinition viewCopy = Schema.instance.getView(this.keyspace(), this.columnFamily()).copy();
        if (this.attrs == null) {
            throw new InvalidRequestException("ALTER MATERIALIZED VIEW WITH invoked, but no parameters found");
        }
        this.attrs.validate();
        TableParams params = this.attrs.asAlteredTableParams(viewCopy.metadata.params);
        if (params.gcGraceSeconds == 0) {
            throw new InvalidRequestException("Cannot alter gc_grace_seconds of a materialized view to 0, since this value is used to TTL undelivered updates. Setting gc_grace_seconds too low might cause undelivered updates to expire before being replayed.");
        }
        viewCopy.metadata.params(params);
        MigrationManager.announceViewUpdate((ViewDefinition)viewCopy, (boolean)isLocalOnly);
        return new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, Event.SchemaChange.Target.TABLE, this.keyspace(), this.columnFamily());
    }

    public String toString() {
        return String.format("AlterViewStatement(name=%s)", this.cfName);
    }
}

