/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.statements;

import com.github.cassandra.jdbc.internal.cassandra.auth.Permission;
import com.github.cassandra.jdbc.internal.cassandra.config.CFMetaData;
import com.github.cassandra.jdbc.internal.cassandra.config.ColumnDefinition;
import com.github.cassandra.jdbc.internal.cassandra.config.Schema;
import com.github.cassandra.jdbc.internal.cassandra.config.ViewDefinition;
import com.github.cassandra.jdbc.internal.cassandra.cql3.CQL3Type;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnIdentifier;
import com.github.cassandra.jdbc.internal.cassandra.cql3.UTName;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.CreateTypeStatement;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.SchemaAlteringStatement;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.AbstractType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.CollectionType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.CompositeType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.ListType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.MapType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.SetType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.TupleType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.UserType;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.ConfigurationException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.InvalidRequestException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.RequestValidationException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.UnauthorizedException;
import com.github.cassandra.jdbc.internal.cassandra.schema.KeyspaceMetadata;
import com.github.cassandra.jdbc.internal.cassandra.service.ClientState;
import com.github.cassandra.jdbc.internal.cassandra.service.MigrationManager;
import com.github.cassandra.jdbc.internal.cassandra.transport.Event;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AlterTypeStatement
extends SchemaAlteringStatement {
    protected final UTName name;

    protected AlterTypeStatement(UTName name) {
        this.name = name;
    }

    @Override
    public void prepareKeyspace(ClientState state) throws InvalidRequestException {
        if (!this.name.hasKeyspace()) {
            this.name.setKeyspace(state.getKeyspace());
        }
        if (this.name.getKeyspace() == null) {
            throw new InvalidRequestException("You need to be logged in a keyspace or use a fully qualified user type name");
        }
    }

    protected abstract UserType makeUpdatedType(UserType var1, KeyspaceMetadata var2) throws InvalidRequestException;

    public static AlterTypeStatement addition(UTName name, ColumnIdentifier fieldName, CQL3Type.Raw type) {
        return new AddOrAlter(name, true, fieldName, type);
    }

    public static AlterTypeStatement alter(UTName name, ColumnIdentifier fieldName, CQL3Type.Raw type) {
        return new AddOrAlter(name, false, fieldName, type);
    }

    public static AlterTypeStatement renames(UTName name, Map<ColumnIdentifier, ColumnIdentifier> renames) {
        return new Renames(name, renames);
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        state.hasKeyspaceAccess(this.keyspace(), Permission.ALTER);
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
    }

    @Override
    public String keyspace() {
        return this.name.getKeyspace();
    }

    @Override
    public Event.SchemaChange announceMigration(boolean isLocalOnly) throws InvalidRequestException, ConfigurationException {
        boolean modified;
        Object copy;
        KeyspaceMetadata ksm = Schema.instance.getKSMetaData(this.name.getKeyspace());
        if (ksm == null) {
            throw new InvalidRequestException(String.format("Cannot alter type in unknown keyspace %s", this.name.getKeyspace()));
        }
        UserType toUpdate = (UserType)ksm.types.get(this.name.getUserTypeName()).orElseThrow(() -> new InvalidRequestException(String.format("No user type named %s exists.", this.name)));
        UserType updated = this.makeUpdatedType(toUpdate, ksm);
        MigrationManager.announceTypeUpdate((UserType)updated, (boolean)isLocalOnly);
        for (CFMetaData cfm : ksm.tables) {
            copy = cfm.copy();
            modified = false;
            for (ColumnDefinition def : ((CFMetaData)copy).allColumns()) {
                modified |= this.updateDefinition((CFMetaData)copy, def, toUpdate.keyspace, toUpdate.name, updated);
            }
            if (!modified) continue;
            MigrationManager.announceColumnFamilyUpdate((CFMetaData)copy, (boolean)false, (boolean)isLocalOnly);
        }
        for (ViewDefinition view : ksm.views) {
            copy = view.copy();
            modified = false;
            for (ColumnDefinition def : ((ViewDefinition)copy).metadata.allColumns()) {
                modified |= this.updateDefinition(((ViewDefinition)copy).metadata, def, toUpdate.keyspace, toUpdate.name, updated);
            }
            if (!modified) continue;
            MigrationManager.announceViewUpdate((ViewDefinition)copy, (boolean)isLocalOnly);
        }
        for (UserType ut : ksm.types) {
            if (ut.keyspace.equals(toUpdate.keyspace) && ut.name.equals(toUpdate.name)) {
                if (ut.keyspace.equals(updated.keyspace) && ut.name.equals(updated.name)) continue;
                MigrationManager.announceTypeDrop((UserType)ut);
                continue;
            }
            AbstractType<?> upd = AlterTypeStatement.updateWith(ut, toUpdate.keyspace, toUpdate.name, updated);
            if (upd == null) continue;
            MigrationManager.announceTypeUpdate((UserType)((UserType)upd), (boolean)isLocalOnly);
        }
        return new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, Event.SchemaChange.Target.TYPE, this.keyspace(), this.name.getStringTypeName());
    }

    private static int getIdxOfField(UserType type, ColumnIdentifier field) {
        for (int i = 0; i < type.size(); ++i) {
            if (!field.bytes.equals(type.fieldName(i))) continue;
            return i;
        }
        return -1;
    }

    private boolean updateDefinition(CFMetaData cfm, ColumnDefinition def, String keyspace, ByteBuffer toReplace, UserType updated) {
        AbstractType<?> t = AlterTypeStatement.updateWith(def.type, keyspace, toReplace, updated);
        if (t == null) {
            return false;
        }
        cfm.addOrReplaceColumnDefinition(def.withNewType(t));
        return true;
    }

    private static AbstractType<?> updateWith(AbstractType<?> type, String keyspace, ByteBuffer toReplace, UserType updated) {
        if (type instanceof UserType) {
            UserType ut = (UserType)type;
            if (keyspace.equals(ut.keyspace) && toReplace.equals(ut.name)) {
                return updated;
            }
            List<AbstractType<?>> updatedTypes = AlterTypeStatement.updateTypes(ut.fieldTypes(), keyspace, toReplace, updated);
            return updatedTypes == null ? null : new UserType(ut.keyspace, ut.name, new ArrayList<ByteBuffer>(ut.fieldNames()), updatedTypes);
        }
        if (type instanceof TupleType) {
            TupleType tt = (TupleType)type;
            List<AbstractType<?>> updatedTypes = AlterTypeStatement.updateTypes(tt.allTypes(), keyspace, toReplace, updated);
            return updatedTypes == null ? null : new TupleType(updatedTypes);
        }
        if (type instanceof CompositeType) {
            CompositeType ct = (CompositeType)type;
            List<AbstractType<?>> updatedTypes = AlterTypeStatement.updateTypes(ct.types, keyspace, toReplace, updated);
            return updatedTypes == null ? null : CompositeType.getInstance(updatedTypes);
        }
        if (type instanceof CollectionType) {
            if (type instanceof ListType) {
                AbstractType<?> t = AlterTypeStatement.updateWith(((ListType)type).getElementsType(), keyspace, toReplace, updated);
                if (t == null) {
                    return null;
                }
                return ListType.getInstance(t, type.isMultiCell());
            }
            if (type instanceof SetType) {
                AbstractType<?> t = AlterTypeStatement.updateWith(((SetType)type).getElementsType(), keyspace, toReplace, updated);
                if (t == null) {
                    return null;
                }
                return SetType.getInstance(t, type.isMultiCell());
            }
            assert (type instanceof MapType);
            MapType mt = (MapType)type;
            AbstractType<?> k = AlterTypeStatement.updateWith(mt.getKeysType(), keyspace, toReplace, updated);
            AbstractType<?> v = AlterTypeStatement.updateWith(mt.getValuesType(), keyspace, toReplace, updated);
            if (k == null && v == null) {
                return null;
            }
            return MapType.getInstance(k == null ? mt.getKeysType() : k, v == null ? mt.getValuesType() : v, type.isMultiCell());
        }
        return null;
    }

    private static List<AbstractType<?>> updateTypes(List<AbstractType<?>> toUpdate, String keyspace, ByteBuffer toReplace, UserType updated) {
        ArrayList updatedTypes = null;
        for (int i = 0; i < toUpdate.size(); ++i) {
            AbstractType<?> t = AlterTypeStatement.updateWith(toUpdate.get(i), keyspace, toReplace, updated);
            if (t == null) continue;
            if (updatedTypes == null) {
                updatedTypes = new ArrayList(toUpdate);
            }
            updatedTypes.set(i, t);
        }
        return updatedTypes;
    }

    protected void checkTypeNotUsedByAggregate(KeyspaceMetadata ksm) {
        ksm.functions.udas().filter(aggregate -> aggregate.initialCondition() != null && aggregate.stateType().referencesUserType(this.name.getStringTypeName())).findAny().ifPresent(aggregate -> {
            throw new InvalidRequestException(String.format("Cannot alter user type %s as it is still used as an INITCOND by aggregate %s", this.name, aggregate));
        });
    }

    private static class Renames
    extends AlterTypeStatement {
        private final Map<ColumnIdentifier, ColumnIdentifier> renames;

        public Renames(UTName name, Map<ColumnIdentifier, ColumnIdentifier> renames) {
            super(name);
            this.renames = renames;
        }

        @Override
        protected UserType makeUpdatedType(UserType toUpdate, KeyspaceMetadata ksm) throws InvalidRequestException {
            this.checkTypeNotUsedByAggregate(ksm);
            ArrayList<ByteBuffer> newNames = new ArrayList<ByteBuffer>(toUpdate.fieldNames());
            ArrayList newTypes = new ArrayList(toUpdate.fieldTypes());
            for (Map.Entry<ColumnIdentifier, ColumnIdentifier> entry : this.renames.entrySet()) {
                ColumnIdentifier from = entry.getKey();
                ColumnIdentifier to = entry.getValue();
                int idx = AlterTypeStatement.getIdxOfField(toUpdate, from);
                if (idx < 0) {
                    throw new InvalidRequestException(String.format("Unknown field %s in type %s", from, this.name));
                }
                newNames.set(idx, to.bytes);
            }
            UserType updated = new UserType(toUpdate.keyspace, toUpdate.name, newNames, newTypes);
            CreateTypeStatement.checkForDuplicateNames(updated);
            return updated;
        }
    }

    private static class AddOrAlter
    extends AlterTypeStatement {
        private final boolean isAdd;
        private final ColumnIdentifier fieldName;
        private final CQL3Type.Raw type;

        public AddOrAlter(UTName name, boolean isAdd, ColumnIdentifier fieldName, CQL3Type.Raw type) {
            super(name);
            this.isAdd = isAdd;
            this.fieldName = fieldName;
            this.type = type;
        }

        private UserType doAdd(UserType toUpdate) throws InvalidRequestException {
            if (AlterTypeStatement.getIdxOfField(toUpdate, this.fieldName) >= 0) {
                throw new InvalidRequestException(String.format("Cannot add new field %s to type %s: a field of the same name already exists", this.fieldName, this.name));
            }
            ArrayList<ByteBuffer> newNames = new ArrayList<ByteBuffer>(toUpdate.size() + 1);
            newNames.addAll(toUpdate.fieldNames());
            newNames.add(this.fieldName.bytes);
            AbstractType<?> addType = this.type.prepare(this.keyspace()).getType();
            if (addType.referencesUserType(toUpdate.getNameAsString())) {
                throw new InvalidRequestException(String.format("Cannot add new field %s of type %s to type %s as this would create a circular reference", this.fieldName, this.type, this.name));
            }
            ArrayList newTypes = new ArrayList(toUpdate.size() + 1);
            newTypes.addAll(toUpdate.fieldTypes());
            newTypes.add(addType);
            return new UserType(toUpdate.keyspace, toUpdate.name, newNames, newTypes);
        }

        private UserType doAlter(UserType toUpdate, KeyspaceMetadata ksm) throws InvalidRequestException {
            this.checkTypeNotUsedByAggregate(ksm);
            int idx = AlterTypeStatement.getIdxOfField(toUpdate, this.fieldName);
            if (idx < 0) {
                throw new InvalidRequestException(String.format("Unknown field %s in type %s", this.fieldName, this.name));
            }
            AbstractType<?> previous = toUpdate.fieldType(idx);
            if (!this.type.prepare(this.keyspace()).getType().isCompatibleWith(previous)) {
                throw new InvalidRequestException(String.format("Type %s is incompatible with previous type %s of field %s in user type %s", this.type, previous.asCQL3Type(), this.fieldName, this.name));
            }
            ArrayList<ByteBuffer> newNames = new ArrayList<ByteBuffer>(toUpdate.fieldNames());
            ArrayList newTypes = new ArrayList(toUpdate.fieldTypes());
            newTypes.set(idx, this.type.prepare(this.keyspace()).getType());
            return new UserType(toUpdate.keyspace, toUpdate.name, newNames, newTypes);
        }

        @Override
        protected UserType makeUpdatedType(UserType toUpdate, KeyspaceMetadata ksm) throws InvalidRequestException {
            return this.isAdd ? this.doAdd(toUpdate) : this.doAlter(toUpdate, ksm);
        }
    }
}

