/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.statements;

import com.github.cassandra.jdbc.internal.cassandra.auth.Permission;
import com.github.cassandra.jdbc.internal.cassandra.config.Schema;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.KeyspaceAttributes;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.SchemaAlteringStatement;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.ConfigurationException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.InvalidRequestException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.RequestValidationException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.UnauthorizedException;
import com.github.cassandra.jdbc.internal.cassandra.locator.LocalStrategy;
import com.github.cassandra.jdbc.internal.cassandra.schema.KeyspaceMetadata;
import com.github.cassandra.jdbc.internal.cassandra.schema.KeyspaceParams;
import com.github.cassandra.jdbc.internal.cassandra.service.ClientState;
import com.github.cassandra.jdbc.internal.cassandra.service.MigrationManager;
import com.github.cassandra.jdbc.internal.cassandra.transport.Event;

public class AlterKeyspaceStatement
extends SchemaAlteringStatement {
    private final String name;
    private final KeyspaceAttributes attrs;

    public AlterKeyspaceStatement(String name, KeyspaceAttributes attrs) {
        this.name = name;
        this.attrs = attrs;
    }

    @Override
    public String keyspace() {
        return this.name;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        state.hasKeyspaceAccess(this.name, Permission.ALTER);
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        KeyspaceMetadata ksm = Schema.instance.getKSMetaData(this.name);
        if (ksm == null) {
            throw new InvalidRequestException("Unknown keyspace " + this.name);
        }
        if (Schema.isSystemKeyspace(ksm.name)) {
            throw new InvalidRequestException("Cannot alter system keyspace");
        }
        this.attrs.validate();
        if (this.attrs.getReplicationStrategyClass() == null && !this.attrs.getReplicationOptions().isEmpty()) {
            throw new ConfigurationException("Missing replication strategy class");
        }
        if (this.attrs.getReplicationStrategyClass() != null) {
            KeyspaceParams params = this.attrs.asAlteredKeyspaceParams(ksm.params);
            params.validate(this.name);
            if (params.replication.klass.equals(LocalStrategy.class)) {
                throw new ConfigurationException("Unable to use given strategy class: LocalStrategy is reserved for internal use.");
            }
        }
    }

    @Override
    public Event.SchemaChange announceMigration(boolean isLocalOnly) throws RequestValidationException {
        KeyspaceMetadata oldKsm = Schema.instance.getKSMetaData(this.name);
        if (oldKsm == null) {
            throw new InvalidRequestException("Unknown keyspace " + this.name);
        }
        KeyspaceMetadata newKsm = oldKsm.withSwapped(this.attrs.asAlteredKeyspaceParams(oldKsm.params));
        MigrationManager.announceKeyspaceUpdate((KeyspaceMetadata)newKsm, (boolean)isLocalOnly);
        return new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, this.keyspace());
    }
}

