/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.selection;

import com.github.cassandra.jdbc.internal.cassandra.config.ColumnDefinition;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnSpecification;
import com.github.cassandra.jdbc.internal.cassandra.cql3.selection.Selection;
import com.github.cassandra.jdbc.internal.cassandra.cql3.selection.SelectionColumnMapping;
import com.github.cassandra.jdbc.internal.cassandra.cql3.selection.Selector;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.AbstractType;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.InvalidRequestException;
import java.nio.ByteBuffer;

public final class SimpleSelector
extends Selector {
    private final String columnName;
    private final int idx;
    private final AbstractType<?> type;
    private ByteBuffer current;
    private boolean isSet;

    public static Selector.Factory newFactory(final ColumnDefinition def, final int idx) {
        return new Selector.Factory(){

            @Override
            protected String getColumnName() {
                return def.name.toString();
            }

            @Override
            protected AbstractType<?> getReturnType() {
                return def.type;
            }

            @Override
            protected void addColumnMapping(SelectionColumnMapping mapping, ColumnSpecification resultColumn) {
                mapping.addMapping(resultColumn, def);
            }

            @Override
            public Selector newInstance() {
                return new SimpleSelector(def.name.toString(), idx, def.type);
            }

            @Override
            public boolean isSimpleSelectorFactory(int index) {
                return index == idx;
            }
        };
    }

    @Override
    public void addInput(int protocolVersion, Selection.ResultSetBuilder rs) throws InvalidRequestException {
        if (!this.isSet) {
            this.isSet = true;
            this.current = rs.current.get(this.idx);
        }
    }

    @Override
    public ByteBuffer getOutput(int protocolVersion) throws InvalidRequestException {
        return this.current;
    }

    @Override
    public void reset() {
        this.isSet = false;
        this.current = null;
    }

    @Override
    public AbstractType<?> getType() {
        return this.type;
    }

    public String toString() {
        return this.columnName;
    }

    private SimpleSelector(String columnName, int idx, AbstractType<?> type) {
        this.columnName = columnName;
        this.idx = idx;
        this.type = type;
    }
}

