/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.selection;

import com.github.cassandra.jdbc.internal.cassandra.config.CFMetaData;
import com.github.cassandra.jdbc.internal.cassandra.config.ColumnDefinition;
import com.github.cassandra.jdbc.internal.cassandra.cql3.selection.Selectable;
import com.github.cassandra.jdbc.internal.cassandra.cql3.selection.Selector;
import com.github.cassandra.jdbc.internal.cassandra.cql3.selection.SimpleSelector;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.AbstractType;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.InvalidRequestException;
import com.github.cassandra.jdbc.internal.google.common.base.Function;
import com.github.cassandra.jdbc.internal.google.common.collect.Iterables;
import com.github.cassandra.jdbc.internal.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

final class SelectorFactories
implements Iterable<Selector.Factory> {
    private final List<Selector.Factory> factories;
    private boolean containsWritetimeFactory;
    private boolean containsTTLFactory;
    private int numberOfAggregateFactories;

    public static SelectorFactories createFactoriesAndCollectColumnDefinitions(List<Selectable> selectables, CFMetaData cfm, List<ColumnDefinition> defs) throws InvalidRequestException {
        return new SelectorFactories(selectables, cfm, defs);
    }

    private SelectorFactories(List<Selectable> selectables, CFMetaData cfm, List<ColumnDefinition> defs) throws InvalidRequestException {
        this.factories = new ArrayList<Selector.Factory>(selectables.size());
        for (Selectable selectable : selectables) {
            Selector.Factory factory = selectable.newSelectorFactory(cfm, defs);
            this.containsWritetimeFactory |= factory.isWritetimeSelectorFactory();
            this.containsTTLFactory |= factory.isTTLSelectorFactory();
            if (factory.isAggregateSelectorFactory()) {
                ++this.numberOfAggregateFactories;
            }
            this.factories.add(factory);
        }
    }

    public Iterable<com.github.cassandra.jdbc.internal.cassandra.cql3.functions.Function> getFunctions() {
        Iterable<com.github.cassandra.jdbc.internal.cassandra.cql3.functions.Function> functions = Collections.emptySet();
        for (Selector.Factory factory : this.factories) {
            if (factory == null) continue;
            functions = Iterables.concat(functions, factory.getFunctions());
        }
        return functions;
    }

    public Selector.Factory get(int i) {
        return this.factories.get(i);
    }

    public void addSelectorForOrdering(ColumnDefinition def, int index) {
        this.factories.add(SimpleSelector.newFactory(def, index));
    }

    public boolean doesAggregation() {
        return this.numberOfAggregateFactories > 0;
    }

    public boolean containsWritetimeSelectorFactory() {
        return this.containsWritetimeFactory;
    }

    public boolean containsTTLSelectorFactory() {
        return this.containsTTLFactory;
    }

    public List<Selector> newInstances() throws InvalidRequestException {
        ArrayList<Selector> selectors = new ArrayList<Selector>(this.factories.size());
        for (Selector.Factory factory : this.factories) {
            selectors.add(factory.newInstance());
        }
        return selectors;
    }

    @Override
    public Iterator<Selector.Factory> iterator() {
        return this.factories.iterator();
    }

    public List<String> getColumnNames() {
        return Lists.transform(this.factories, new Function<Selector.Factory, String>(){

            @Override
            public String apply(Selector.Factory factory) {
                return factory.getColumnName();
            }
        });
    }

    public List<AbstractType<?>> getReturnTypes() {
        return Lists.transform(this.factories, new Function<Selector.Factory, AbstractType<?>>(){

            @Override
            public AbstractType<?> apply(Selector.Factory factory) {
                return factory.getReturnType();
            }
        });
    }

    public int size() {
        return this.factories.size();
    }
}

