/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.selection;

import com.github.cassandra.jdbc.internal.cassandra.config.ColumnDefinition;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnSpecification;
import com.github.cassandra.jdbc.internal.cassandra.cql3.selection.SelectionColumns;
import com.github.cassandra.jdbc.internal.google.common.base.Objects;
import com.github.cassandra.jdbc.internal.google.common.collect.HashMultimap;
import com.github.cassandra.jdbc.internal.google.common.collect.Lists;
import com.github.cassandra.jdbc.internal.google.common.collect.Multimap;
import com.github.cassandra.jdbc.internal.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class SelectionColumnMapping
implements SelectionColumns {
    private final ArrayList<ColumnSpecification> columnSpecifications = new ArrayList();
    private final HashMultimap<ColumnSpecification, ColumnDefinition> columnMappings = HashMultimap.create();

    private SelectionColumnMapping() {
    }

    protected static SelectionColumnMapping newMapping() {
        return new SelectionColumnMapping();
    }

    protected static SelectionColumnMapping simpleMapping(Iterable<ColumnDefinition> columnDefinitions) {
        SelectionColumnMapping mapping = new SelectionColumnMapping();
        for (ColumnDefinition def : columnDefinitions) {
            mapping.addMapping((ColumnSpecification)def, def);
        }
        return mapping;
    }

    protected SelectionColumnMapping addMapping(ColumnSpecification colSpec, ColumnDefinition column) {
        this.columnSpecifications.add(colSpec);
        if (column != null) {
            this.columnMappings.put((Object)colSpec, (Object)column);
        }
        return this;
    }

    protected SelectionColumnMapping addMapping(ColumnSpecification colSpec, Iterable<ColumnDefinition> columns) {
        this.columnSpecifications.add(colSpec);
        this.columnMappings.putAll((Object)colSpec, columns);
        return this;
    }

    @Override
    public List<ColumnSpecification> getColumnSpecifications() {
        return Lists.newArrayList(this.columnSpecifications);
    }

    @Override
    public Multimap<ColumnSpecification, ColumnDefinition> getMappings() {
        return Multimaps.unmodifiableMultimap(this.columnMappings);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelectionColumnMapping)) {
            return false;
        }
        SelectionColumns other = (SelectionColumns)obj;
        return Objects.equal(this.columnMappings, other.getMappings()) && Objects.equal(this.columnSpecifications, other.getColumnSpecifications());
    }

    public int hashCode() {
        return Objects.hashCode(this.columnMappings);
    }

    public String toString() {
        return this.columnMappings.asMap().entrySet().stream().map(entry -> ((Collection)entry.getValue()).stream().map(colDef -> colDef.name.toString()).collect(Collectors.joining(", ", ((ColumnSpecification)entry.getKey()).name.toString() + ":[", "]"))).collect(Collectors.joining(", ", this.columnSpecifications.stream().map(colSpec -> colSpec.name.toString()).collect(Collectors.joining(", ", "{ Columns:[", "], Mappings:{")), "} }"));
    }
}

