/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.restrictions;

import com.github.cassandra.jdbc.internal.cassandra.config.CFMetaData;
import com.github.cassandra.jdbc.internal.cassandra.config.ColumnDefinition;
import com.github.cassandra.jdbc.internal.cassandra.cql3.QueryOptions;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Term;
import com.github.cassandra.jdbc.internal.cassandra.cql3.functions.Function;
import com.github.cassandra.jdbc.internal.cassandra.cql3.restrictions.AbstractPrimaryKeyRestrictions;
import com.github.cassandra.jdbc.internal.cassandra.cql3.restrictions.PrimaryKeyRestrictionSet;
import com.github.cassandra.jdbc.internal.cassandra.cql3.restrictions.PrimaryKeyRestrictions;
import com.github.cassandra.jdbc.internal.cassandra.cql3.restrictions.Restriction;
import com.github.cassandra.jdbc.internal.cassandra.cql3.restrictions.TermSlice;
import com.github.cassandra.jdbc.internal.cassandra.cql3.restrictions.TokenFilter;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.Bound;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.RequestValidations;
import com.github.cassandra.jdbc.internal.cassandra.db.Clustering;
import com.github.cassandra.jdbc.internal.cassandra.db.MultiCBuilder;
import com.github.cassandra.jdbc.internal.cassandra.db.Slice;
import com.github.cassandra.jdbc.internal.cassandra.db.filter.RowFilter;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.InvalidRequestException;
import com.github.cassandra.jdbc.internal.cassandra.index.SecondaryIndexManager;
import com.github.cassandra.jdbc.internal.google.common.base.Joiner;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;

public abstract class TokenRestriction
extends AbstractPrimaryKeyRestrictions {
    protected final List<ColumnDefinition> columnDefs;
    final CFMetaData metadata;

    public TokenRestriction(CFMetaData metadata, List<ColumnDefinition> columnDefs) {
        super(metadata.getKeyValidatorAsClusteringComparator());
        this.columnDefs = columnDefs;
        this.metadata = metadata;
    }

    @Override
    public boolean isOnToken() {
        return true;
    }

    @Override
    public List<ColumnDefinition> getColumnDefs() {
        return this.columnDefs;
    }

    @Override
    public ColumnDefinition getFirstColumn() {
        return this.columnDefs.get(0);
    }

    @Override
    public ColumnDefinition getLastColumn() {
        return this.columnDefs.get(this.columnDefs.size() - 1);
    }

    @Override
    public boolean hasSupportingIndex(SecondaryIndexManager secondaryIndexManager) {
        return false;
    }

    @Override
    public void addRowFilterTo(RowFilter filter, SecondaryIndexManager indexManager, QueryOptions options) {
        throw new UnsupportedOperationException("Index expression cannot be created for token restriction");
    }

    @Override
    public MultiCBuilder appendTo(MultiCBuilder builder, QueryOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NavigableSet<Clustering> valuesAsClustering(QueryOptions options) throws InvalidRequestException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NavigableSet<Slice.Bound> boundsAsClustering(Bound bound, QueryOptions options) throws InvalidRequestException {
        throw new UnsupportedOperationException();
    }

    protected final String getColumnNamesAsString() {
        return Joiner.on(", ").join(ColumnDefinition.toIdentifiers(this.columnDefs));
    }

    @Override
    public final PrimaryKeyRestrictions mergeWith(Restriction otherRestriction) throws InvalidRequestException {
        if (!otherRestriction.isOnToken()) {
            return new TokenFilter(this.toPrimaryKeyRestriction(otherRestriction), this);
        }
        return this.doMergeWith((TokenRestriction)otherRestriction);
    }

    protected abstract PrimaryKeyRestrictions doMergeWith(TokenRestriction var1) throws InvalidRequestException;

    private PrimaryKeyRestrictions toPrimaryKeyRestriction(Restriction restriction) throws InvalidRequestException {
        if (restriction instanceof PrimaryKeyRestrictions) {
            return (PrimaryKeyRestrictions)restriction;
        }
        return new PrimaryKeyRestrictionSet(this.comparator, true).mergeWith(restriction);
    }

    public static class SliceRestriction
    extends TokenRestriction {
        private final TermSlice slice;

        public SliceRestriction(CFMetaData cfm, List<ColumnDefinition> columnDefs, Bound bound, boolean inclusive, Term term) {
            super(cfm, columnDefs);
            this.slice = TermSlice.newInstance(bound, inclusive, term);
        }

        @Override
        public boolean isSlice() {
            return true;
        }

        @Override
        public List<ByteBuffer> values(QueryOptions options) throws InvalidRequestException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasBound(Bound b) {
            return this.slice.hasBound(b);
        }

        @Override
        public List<ByteBuffer> bounds(Bound b, QueryOptions options) throws InvalidRequestException {
            return Collections.singletonList(this.slice.bound(b).bindAndGet(options));
        }

        @Override
        public Iterable<Function> getFunctions() {
            return this.slice.getFunctions();
        }

        @Override
        public boolean isInclusive(Bound b) {
            return this.slice.isInclusive(b);
        }

        @Override
        protected PrimaryKeyRestrictions doMergeWith(TokenRestriction otherRestriction) throws InvalidRequestException {
            if (!otherRestriction.isSlice()) {
                throw RequestValidations.invalidRequest("Columns \"%s\" cannot be restricted by both an equality and an inequality relation", this.getColumnNamesAsString());
            }
            SliceRestriction otherSlice = (SliceRestriction)otherRestriction;
            if (this.hasBound(Bound.START) && otherSlice.hasBound(Bound.START)) {
                throw RequestValidations.invalidRequest("More than one restriction was found for the start bound on %s", this.getColumnNamesAsString());
            }
            if (this.hasBound(Bound.END) && otherSlice.hasBound(Bound.END)) {
                throw RequestValidations.invalidRequest("More than one restriction was found for the end bound on %s", this.getColumnNamesAsString());
            }
            return new SliceRestriction(this.metadata, this.columnDefs, this.slice.merge(otherSlice.slice));
        }

        public String toString() {
            return String.format("SLICE%s", this.slice);
        }

        private SliceRestriction(CFMetaData cfm, List<ColumnDefinition> columnDefs, TermSlice slice) {
            super(cfm, columnDefs);
            this.slice = slice;
        }
    }

    public static final class EQRestriction
    extends TokenRestriction {
        private final Term value;

        public EQRestriction(CFMetaData cfm, List<ColumnDefinition> columnDefs, Term value) {
            super(cfm, columnDefs);
            this.value = value;
        }

        @Override
        public boolean isEQ() {
            return true;
        }

        @Override
        public Iterable<Function> getFunctions() {
            return this.value.getFunctions();
        }

        @Override
        protected PrimaryKeyRestrictions doMergeWith(TokenRestriction otherRestriction) throws InvalidRequestException {
            throw RequestValidations.invalidRequest("%s cannot be restricted by more than one relation if it includes an Equal", Joiner.on(", ").join(ColumnDefinition.toIdentifiers(this.columnDefs)));
        }

        @Override
        public List<ByteBuffer> values(QueryOptions options) throws InvalidRequestException {
            return Collections.singletonList(this.value.bindAndGet(options));
        }
    }
}

