/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.restrictions;

import com.github.cassandra.jdbc.internal.cassandra.config.ColumnDefinition;
import com.github.cassandra.jdbc.internal.cassandra.cql3.QueryOptions;
import com.github.cassandra.jdbc.internal.cassandra.cql3.functions.Function;
import com.github.cassandra.jdbc.internal.cassandra.cql3.restrictions.Restriction;
import com.github.cassandra.jdbc.internal.cassandra.cql3.restrictions.Restrictions;
import com.github.cassandra.jdbc.internal.cassandra.cql3.restrictions.SingleColumnRestriction;
import com.github.cassandra.jdbc.internal.cassandra.db.filter.RowFilter;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.InvalidRequestException;
import com.github.cassandra.jdbc.internal.cassandra.index.SecondaryIndexManager;
import com.github.cassandra.jdbc.internal.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

final class RestrictionSet
implements Restrictions,
Iterable<Restriction> {
    private static final Comparator<ColumnDefinition> COLUMN_DEFINITION_COMPARATOR = new Comparator<ColumnDefinition>(){

        @Override
        public int compare(ColumnDefinition column, ColumnDefinition otherColumn) {
            int value = Integer.compare(column.position(), otherColumn.position());
            return value != 0 ? value : column.name.bytes.compareTo(otherColumn.name.bytes);
        }
    };
    protected final TreeMap<ColumnDefinition, Restriction> restrictions;

    public RestrictionSet() {
        this(new TreeMap<ColumnDefinition, Restriction>(COLUMN_DEFINITION_COMPARATOR));
    }

    private RestrictionSet(TreeMap<ColumnDefinition, Restriction> restrictions) {
        this.restrictions = restrictions;
    }

    @Override
    public final void addRowFilterTo(RowFilter filter, SecondaryIndexManager indexManager, QueryOptions options) throws InvalidRequestException {
        for (Restriction restriction : this.restrictions.values()) {
            restriction.addRowFilterTo(filter, indexManager, options);
        }
    }

    public final List<ColumnDefinition> getColumnDefs() {
        return new ArrayList<ColumnDefinition>(this.restrictions.keySet());
    }

    @Override
    public Iterable<Function> getFunctions() {
        com.github.cassandra.jdbc.internal.google.common.base.Function<Restriction, Iterable<Function>> transform = new com.github.cassandra.jdbc.internal.google.common.base.Function<Restriction, Iterable<Function>>(){

            @Override
            public Iterable<Function> apply(Restriction restriction) {
                return restriction.getFunctions();
            }
        };
        return Iterables.concat(Iterables.transform(this.restrictions.values(), transform));
    }

    @Override
    public final boolean isEmpty() {
        return this.restrictions.isEmpty();
    }

    @Override
    public final int size() {
        return this.restrictions.size();
    }

    public RestrictionSet addRestriction(Restriction restriction) throws InvalidRequestException {
        TreeMap<ColumnDefinition, Restriction> newRestrictions = new TreeMap<ColumnDefinition, Restriction>((SortedMap<ColumnDefinition, Restriction>)this.restrictions);
        return new RestrictionSet(this.mergeRestrictions(newRestrictions, restriction));
    }

    private TreeMap<ColumnDefinition, Restriction> mergeRestrictions(TreeMap<ColumnDefinition, Restriction> restrictions, Restriction restriction) throws InvalidRequestException {
        List<ColumnDefinition> columnDefs = restriction.getColumnDefs();
        Set<Restriction> existingRestrictions = this.getRestrictions(columnDefs);
        if (existingRestrictions.isEmpty()) {
            for (ColumnDefinition columnDef : columnDefs) {
                restrictions.put(columnDef, restriction);
            }
        } else {
            for (Restriction existing : existingRestrictions) {
                Restriction newRestriction = RestrictionSet.mergeRestrictions(existing, restriction);
                for (ColumnDefinition columnDef : columnDefs) {
                    restrictions.put(columnDef, newRestriction);
                }
            }
        }
        return restrictions;
    }

    private Set<Restriction> getRestrictions(Collection<ColumnDefinition> columnDefs) {
        HashSet<Restriction> set = new HashSet<Restriction>();
        for (ColumnDefinition columnDef : columnDefs) {
            Restriction existing = this.restrictions.get(columnDef);
            if (existing == null) continue;
            set.add(existing);
        }
        return set;
    }

    @Override
    public final boolean hasSupportingIndex(SecondaryIndexManager indexManager) {
        for (Restriction restriction : this.restrictions.values()) {
            if (!restriction.hasSupportingIndex(indexManager)) continue;
            return true;
        }
        return false;
    }

    ColumnDefinition nextColumn(ColumnDefinition columnDef) {
        return (ColumnDefinition)this.restrictions.tailMap(columnDef, false).firstKey();
    }

    ColumnDefinition firstColumn() {
        return this.isEmpty() ? null : this.restrictions.firstKey();
    }

    ColumnDefinition lastColumn() {
        return this.isEmpty() ? null : this.restrictions.lastKey();
    }

    Restriction lastRestriction() {
        return this.isEmpty() ? null : this.restrictions.lastEntry().getValue();
    }

    private static Restriction mergeRestrictions(Restriction restriction, Restriction otherRestriction) throws InvalidRequestException {
        return restriction == null ? otherRestriction : restriction.mergeWith(otherRestriction);
    }

    public final boolean hasMultipleContains() {
        int numberOfContains = 0;
        for (Restriction restriction : this.restrictions.values()) {
            if (!restriction.isContains()) continue;
            SingleColumnRestriction.ContainsRestriction contains = (SingleColumnRestriction.ContainsRestriction)restriction;
            numberOfContains += contains.numberOfValues() + contains.numberOfKeys() + contains.numberOfEntries();
        }
        return numberOfContains > 1;
    }

    @Override
    public Iterator<Restriction> iterator() {
        return new LinkedHashSet<Restriction>(this.restrictions.values()).iterator();
    }
}

