/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.restrictions;

import com.github.cassandra.jdbc.internal.cassandra.config.CFMetaData;
import com.github.cassandra.jdbc.internal.cassandra.config.ColumnDefinition;
import com.github.cassandra.jdbc.internal.cassandra.cql3.QueryOptions;
import com.github.cassandra.jdbc.internal.cassandra.cql3.functions.Function;
import com.github.cassandra.jdbc.internal.cassandra.cql3.restrictions.AbstractPrimaryKeyRestrictions;
import com.github.cassandra.jdbc.internal.cassandra.cql3.restrictions.PrimaryKeyRestrictions;
import com.github.cassandra.jdbc.internal.cassandra.cql3.restrictions.Restriction;
import com.github.cassandra.jdbc.internal.cassandra.cql3.restrictions.RestrictionSet;
import com.github.cassandra.jdbc.internal.cassandra.cql3.restrictions.TokenFilter;
import com.github.cassandra.jdbc.internal.cassandra.cql3.restrictions.TokenRestriction;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.Bound;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.RequestValidations;
import com.github.cassandra.jdbc.internal.cassandra.db.Clustering;
import com.github.cassandra.jdbc.internal.cassandra.db.ClusteringComparator;
import com.github.cassandra.jdbc.internal.cassandra.db.ClusteringPrefix;
import com.github.cassandra.jdbc.internal.cassandra.db.MultiCBuilder;
import com.github.cassandra.jdbc.internal.cassandra.db.Slice;
import com.github.cassandra.jdbc.internal.cassandra.db.filter.RowFilter;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.InvalidRequestException;
import com.github.cassandra.jdbc.internal.cassandra.index.SecondaryIndexManager;
import com.github.cassandra.jdbc.internal.cassandra.utils.btree.BTreeSet;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.SortedSet;

final class PrimaryKeyRestrictionSet
extends AbstractPrimaryKeyRestrictions {
    private final RestrictionSet restrictions;
    private boolean eq;
    private boolean in;
    private boolean like;
    private boolean slice;
    private boolean contains;
    private boolean isPartitionKey;

    public PrimaryKeyRestrictionSet(ClusteringComparator comparator, boolean isPartitionKey) {
        super(comparator);
        this.restrictions = new RestrictionSet();
        this.eq = true;
        this.isPartitionKey = isPartitionKey;
    }

    private PrimaryKeyRestrictionSet(PrimaryKeyRestrictionSet primaryKeyRestrictions, Restriction restriction) throws InvalidRequestException {
        super(primaryKeyRestrictions.comparator);
        this.restrictions = primaryKeyRestrictions.restrictions.addRestriction(restriction);
        this.isPartitionKey = primaryKeyRestrictions.isPartitionKey;
        if (!primaryKeyRestrictions.isEmpty()) {
            ColumnDefinition lastRestrictionStart = primaryKeyRestrictions.restrictions.lastRestriction().getFirstColumn();
            ColumnDefinition newRestrictionStart = restriction.getFirstColumn();
            RequestValidations.checkFalse(primaryKeyRestrictions.isSlice() && newRestrictionStart.position() > lastRestrictionStart.position(), "Clustering column \"%s\" cannot be restricted (preceding column \"%s\" is restricted by a non-EQ relation)", newRestrictionStart.name, lastRestrictionStart.name);
            if (newRestrictionStart.position() < lastRestrictionStart.position() && restriction.isSlice()) {
                throw RequestValidations.invalidRequest("PRIMARY KEY column \"%s\" cannot be restricted (preceding column \"%s\" is restricted by a non-EQ relation)", this.restrictions.nextColumn((ColumnDefinition)newRestrictionStart).name, newRestrictionStart.name);
            }
        }
        if (restriction.isSlice() || primaryKeyRestrictions.isSlice()) {
            this.slice = true;
        } else if (restriction.isContains() || primaryKeyRestrictions.isContains()) {
            this.contains = true;
        } else if (restriction.isIN() || primaryKeyRestrictions.isIN()) {
            this.in = true;
        } else if (restriction.isLIKE() || primaryKeyRestrictions.isLIKE()) {
            this.like = true;
        } else {
            this.eq = true;
        }
    }

    private List<ByteBuffer> toByteBuffers(SortedSet<? extends ClusteringPrefix> clusterings) {
        ArrayList<ByteBuffer> l = new ArrayList<ByteBuffer>(clusterings.size());
        for (ClusteringPrefix clusteringPrefix : clusterings) {
            l.add(CFMetaData.serializePartitionKey(clusteringPrefix));
        }
        return l;
    }

    @Override
    public boolean isSlice() {
        return this.slice;
    }

    @Override
    public boolean isEQ() {
        return this.eq;
    }

    @Override
    public boolean isIN() {
        return this.in;
    }

    @Override
    public boolean isLIKE() {
        return this.like;
    }

    @Override
    public boolean isContains() {
        return this.contains;
    }

    @Override
    public Iterable<Function> getFunctions() {
        return this.restrictions.getFunctions();
    }

    @Override
    public PrimaryKeyRestrictions mergeWith(Restriction restriction) throws InvalidRequestException {
        if (restriction.isOnToken()) {
            if (this.isEmpty()) {
                return (PrimaryKeyRestrictions)restriction;
            }
            return new TokenFilter(this, (TokenRestriction)restriction);
        }
        return new PrimaryKeyRestrictionSet(this, restriction);
    }

    private boolean hasIN() {
        if (this.isIN()) {
            return true;
        }
        for (Restriction restriction : this.restrictions) {
            if (!restriction.isIN()) continue;
            return true;
        }
        return false;
    }

    private boolean hasMultiColumnSlice() {
        for (Restriction restriction : this.restrictions) {
            if (!restriction.isMultiColumn() || !restriction.isSlice()) continue;
            return true;
        }
        return false;
    }

    @Override
    public NavigableSet<Clustering> valuesAsClustering(QueryOptions options) throws InvalidRequestException {
        return this.appendTo(MultiCBuilder.create((ClusteringComparator)this.comparator, (boolean)this.hasIN()), options).build();
    }

    @Override
    public MultiCBuilder appendTo(MultiCBuilder builder, QueryOptions options) {
        for (Restriction r : this.restrictions) {
            r.appendTo(builder, options);
            if (!builder.hasMissingElements()) continue;
            break;
        }
        return builder;
    }

    @Override
    public MultiCBuilder appendBoundTo(MultiCBuilder builder, Bound bound, QueryOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NavigableSet<Slice.Bound> boundsAsClustering(Bound bound, QueryOptions options) throws InvalidRequestException {
        Restriction r;
        ColumnDefinition def;
        MultiCBuilder builder = MultiCBuilder.create((ClusteringComparator)this.comparator, (this.hasIN() || this.hasMultiColumnSlice() ? 1 : 0) != 0);
        int keyPosition = 0;
        Iterator<Restriction> iterator = this.restrictions.iterator();
        while (iterator.hasNext() && keyPosition == (def = (r = iterator.next()).getFirstColumn()).position() && !r.isContains() && !r.isLIKE()) {
            if (r.isSlice()) {
                r.appendBoundTo(builder, bound, options);
                return builder.buildBoundForSlice(bound.isStart(), r.isInclusive(bound), r.isInclusive(bound.reverse()), r.getColumnDefs());
            }
            r.appendBoundTo(builder, bound, options);
            if (builder.hasMissingElements()) {
                return BTreeSet.empty((Comparator)this.comparator);
            }
            keyPosition = r.getLastColumn().position() + 1;
        }
        return builder.buildBound(bound.isStart(), true);
    }

    @Override
    public List<ByteBuffer> values(QueryOptions options) throws InvalidRequestException {
        if (!this.isPartitionKey) {
            throw new UnsupportedOperationException();
        }
        return this.toByteBuffers(this.valuesAsClustering(options));
    }

    @Override
    public List<ByteBuffer> bounds(Bound b, QueryOptions options) throws InvalidRequestException {
        if (!this.isPartitionKey) {
            throw new UnsupportedOperationException();
        }
        return this.toByteBuffers(this.boundsAsClustering(b, options));
    }

    @Override
    public boolean hasBound(Bound b) {
        if (this.isEmpty()) {
            return false;
        }
        return this.restrictions.lastRestriction().hasBound(b);
    }

    @Override
    public boolean isInclusive(Bound b) {
        if (this.isEmpty()) {
            return false;
        }
        return this.restrictions.lastRestriction().isInclusive(b);
    }

    @Override
    public boolean hasSupportingIndex(SecondaryIndexManager indexManager) {
        return this.restrictions.hasSupportingIndex(indexManager);
    }

    @Override
    public void addRowFilterTo(RowFilter filter, SecondaryIndexManager indexManager, QueryOptions options) throws InvalidRequestException {
        int position = 0;
        for (Restriction restriction : this.restrictions) {
            ColumnDefinition columnDef = restriction.getFirstColumn();
            if (!(this.isPartitionKey || restriction.isContains() || restriction.isLIKE() || position != columnDef.position())) {
                position = restriction.getLastColumn().position() + 1;
                if (!restriction.hasSupportingIndex(indexManager)) continue;
            }
            restriction.addRowFilterTo(filter, indexManager, options);
        }
    }

    @Override
    public List<ColumnDefinition> getColumnDefs() {
        return this.restrictions.getColumnDefs();
    }

    @Override
    public ColumnDefinition getFirstColumn() {
        return this.restrictions.firstColumn();
    }

    @Override
    public ColumnDefinition getLastColumn() {
        return this.restrictions.lastColumn();
    }
}

