/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.restrictions;

import com.github.cassandra.jdbc.internal.cassandra.config.CFMetaData;
import com.github.cassandra.jdbc.internal.cassandra.cql3.IndexName;
import com.github.cassandra.jdbc.internal.cassandra.cql3.restrictions.CustomIndexExpression;
import com.github.cassandra.jdbc.internal.cassandra.cql3.restrictions.Restrictions;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.InvalidRequestException;
import java.util.ArrayList;
import java.util.List;

public class IndexRestrictions {
    public static final String INDEX_NOT_FOUND = "Invalid index expression, index %s not found for %s.%s";
    public static final String INVALID_INDEX = "Target index %s cannot be used to query %s.%s";
    public static final String CUSTOM_EXPRESSION_NOT_SUPPORTED = "Index %s does not support custom expressions";
    public static final String NON_CUSTOM_INDEX_IN_EXPRESSION = "Only CUSTOM indexes may be used in custom index expressions, %s is not valid";
    public static final String MULTIPLE_EXPRESSIONS = "Multiple custom index expressions in a single query are not supported";
    private final List<Restrictions> regularRestrictions = new ArrayList<Restrictions>();
    private final List<CustomIndexExpression> customExpressions = new ArrayList<CustomIndexExpression>();

    public void add(Restrictions restrictions) {
        this.regularRestrictions.add(restrictions);
    }

    public void add(CustomIndexExpression expression) {
        this.customExpressions.add(expression);
    }

    public boolean isEmpty() {
        return this.regularRestrictions.isEmpty() && this.customExpressions.isEmpty();
    }

    public List<Restrictions> getRestrictions() {
        return this.regularRestrictions;
    }

    public List<CustomIndexExpression> getCustomIndexExpressions() {
        return this.customExpressions;
    }

    static InvalidRequestException invalidIndex(IndexName indexName, CFMetaData cfm) {
        return new InvalidRequestException(String.format(INVALID_INDEX, indexName.getIdx(), cfm.ksName, cfm.cfName));
    }

    static InvalidRequestException indexNotFound(IndexName indexName, CFMetaData cfm) {
        return new InvalidRequestException(String.format(INDEX_NOT_FOUND, indexName.getIdx(), cfm.ksName, cfm.cfName));
    }

    static InvalidRequestException nonCustomIndexInExpression(IndexName indexName) {
        return new InvalidRequestException(String.format(NON_CUSTOM_INDEX_IN_EXPRESSION, indexName.getIdx()));
    }

    static InvalidRequestException customExpressionNotSupported(IndexName indexName) {
        return new InvalidRequestException(String.format(CUSTOM_EXPRESSION_NOT_SUPPORTED, indexName.getIdx()));
    }
}

