/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.restrictions;

import com.github.cassandra.jdbc.internal.cassandra.config.CFMetaData;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnIdentifier;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnSpecification;
import com.github.cassandra.jdbc.internal.cassandra.cql3.IndexName;
import com.github.cassandra.jdbc.internal.cassandra.cql3.QueryOptions;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Term;
import com.github.cassandra.jdbc.internal.cassandra.cql3.VariableSpecifications;
import com.github.cassandra.jdbc.internal.cassandra.cql3.restrictions.IndexRestrictions;
import com.github.cassandra.jdbc.internal.cassandra.db.filter.RowFilter;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.AbstractType;
import com.github.cassandra.jdbc.internal.cassandra.schema.IndexMetadata;

public class CustomIndexExpression {
    private final ColumnIdentifier valueColId = new ColumnIdentifier("custom index expression", false);
    public final IndexName targetIndex;
    public final Term.Raw valueRaw;
    private Term value;

    public CustomIndexExpression(IndexName targetIndex, Term.Raw value) {
        this.targetIndex = targetIndex;
        this.valueRaw = value;
    }

    public void prepareValue(CFMetaData cfm, AbstractType<?> expressionType, VariableSpecifications boundNames) {
        ColumnSpecification spec = new ColumnSpecification(cfm.ksName, cfm.ksName, this.valueColId, expressionType);
        this.value = this.valueRaw.prepare(cfm.ksName, spec);
        this.value.collectMarkerSpecification(boundNames);
    }

    public void addToRowFilter(RowFilter filter, CFMetaData cfm, QueryOptions options) {
        filter.addCustomIndexExpression(cfm, (IndexMetadata)cfm.getIndexes().get(this.targetIndex.getIdx()).orElseThrow(() -> IndexRestrictions.indexNotFound(this.targetIndex, cfm)), this.value.bindAndGet(options));
    }
}

