/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.functions;

import com.github.cassandra.jdbc.internal.cassandra.config.CFMetaData;
import com.github.cassandra.jdbc.internal.cassandra.config.ColumnDefinition;
import com.github.cassandra.jdbc.internal.cassandra.cql3.functions.NativeScalarFunction;
import com.github.cassandra.jdbc.internal.cassandra.db.CBuilder;
import com.github.cassandra.jdbc.internal.cassandra.db.ClusteringComparator;
import com.github.cassandra.jdbc.internal.cassandra.db.ClusteringPrefix;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.AbstractType;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.InvalidRequestException;
import java.nio.ByteBuffer;
import java.util.List;

public class TokenFct
extends NativeScalarFunction {
    private final CFMetaData cfm;

    public TokenFct(CFMetaData cfm) {
        super("token", cfm.partitioner.getTokenValidator(), TokenFct.getKeyTypes(cfm));
        this.cfm = cfm;
    }

    private static AbstractType[] getKeyTypes(CFMetaData cfm) {
        AbstractType[] types = new AbstractType[cfm.partitionKeyColumns().size()];
        int i = 0;
        for (ColumnDefinition def : cfm.partitionKeyColumns()) {
            types[i++] = def.type;
        }
        return types;
    }

    @Override
    public ByteBuffer execute(int protocolVersion, List<ByteBuffer> parameters) throws InvalidRequestException {
        CBuilder builder = CBuilder.create((ClusteringComparator)this.cfm.getKeyValidatorAsClusteringComparator());
        for (int i = 0; i < parameters.size(); ++i) {
            ByteBuffer bb = parameters.get(i);
            if (bb == null) {
                return null;
            }
            builder.add(bb);
        }
        return this.cfm.partitioner.getTokenFactory().toByteArray(this.cfm.partitioner.getToken(CFMetaData.serializePartitionKey((ClusteringPrefix)builder.build())));
    }
}

