/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3.functions;

import com.github.cassandra.jdbc.internal.cassandra.cql3.Json;
import com.github.cassandra.jdbc.internal.cassandra.cql3.QueryOptions;
import com.github.cassandra.jdbc.internal.cassandra.cql3.functions.FunctionName;
import com.github.cassandra.jdbc.internal.cassandra.cql3.functions.NativeScalarFunction;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.AbstractType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.UTF8Type;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.FunctionExecutionException;
import com.github.cassandra.jdbc.internal.cassandra.serializers.MarshalException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FromJsonFct
extends NativeScalarFunction {
    public static final FunctionName NAME = FunctionName.nativeFunction("fromjson");
    private static final Map<AbstractType<?>, FromJsonFct> instances = new ConcurrentHashMap();

    public static FromJsonFct getInstance(AbstractType<?> returnType) {
        FromJsonFct func = instances.get(returnType);
        if (func == null) {
            func = new FromJsonFct(returnType);
            instances.put(returnType, func);
        }
        return func;
    }

    private FromJsonFct(AbstractType<?> returnType) {
        super("fromjson", returnType, UTF8Type.instance);
    }

    @Override
    public ByteBuffer execute(int protocolVersion, List<ByteBuffer> parameters) {
        assert (parameters.size() == 1) : "Unexpectedly got " + parameters.size() + " arguments for fromJson()";
        ByteBuffer argument = parameters.get(0);
        if (argument == null) {
            return null;
        }
        String jsonArg = UTF8Type.instance.getSerializer().deserialize(argument);
        try {
            Object object = Json.JSON_OBJECT_MAPPER.readValue(jsonArg, Object.class);
            if (object == null) {
                return null;
            }
            return this.returnType.fromJSONObject(object).bindAndGet(QueryOptions.forProtocolVersion(protocolVersion));
        }
        catch (IOException exc) {
            throw new FunctionExecutionException(NAME, Collections.singletonList("text"), String.format("Could not decode JSON string '%s': %s", jsonArg, exc.toString()));
        }
        catch (MarshalException exc) {
            throw FunctionExecutionException.create(this, exc);
        }
    }
}

