/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3;

import com.github.cassandra.jdbc.internal.cassandra.cql3.Relation;
import com.github.cassandra.jdbc.internal.cassandra.cql3.restrictions.CustomIndexExpression;
import com.github.cassandra.jdbc.internal.google.common.collect.ImmutableList;
import java.util.List;

public final class WhereClause {
    private static final WhereClause EMPTY = new WhereClause(new Builder());
    public final List<Relation> relations;
    public final List<CustomIndexExpression> expressions;

    private WhereClause(Builder builder) {
        this.relations = builder.relations.build();
        this.expressions = builder.expressions.build();
    }

    public static WhereClause empty() {
        return EMPTY;
    }

    public boolean containsCustomExpressions() {
        return !this.expressions.isEmpty();
    }

    public static final class Builder {
        ImmutableList.Builder<Relation> relations = new ImmutableList.Builder();
        ImmutableList.Builder<CustomIndexExpression> expressions = new ImmutableList.Builder();

        public Builder add(Relation relation) {
            this.relations.add((Object)relation);
            return this;
        }

        public Builder add(CustomIndexExpression expression) {
            this.expressions.add((Object)expression);
            return this;
        }

        public WhereClause build() {
            return new WhereClause(this);
        }
    }
}

