/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3;

import com.github.cassandra.jdbc.internal.cassandra.config.CFMetaData;
import com.github.cassandra.jdbc.internal.cassandra.config.ColumnDefinition;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnIdentifier;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnSpecification;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class VariableSpecifications {
    private final List<ColumnIdentifier> variableNames;
    private final ColumnSpecification[] specs;
    private final ColumnDefinition[] targetColumns;

    public VariableSpecifications(List<ColumnIdentifier> variableNames) {
        this.variableNames = variableNames;
        this.specs = new ColumnSpecification[variableNames.size()];
        this.targetColumns = new ColumnDefinition[variableNames.size()];
    }

    public static VariableSpecifications empty() {
        return new VariableSpecifications(Collections.emptyList());
    }

    public int size() {
        return this.variableNames.size();
    }

    public List<ColumnSpecification> getSpecifications() {
        return Arrays.asList(this.specs);
    }

    public Short[] getPartitionKeyBindIndexes(CFMetaData cfm) {
        Short[] partitionKeyPositions = new Short[cfm.partitionKeyColumns().size()];
        for (int i = 0; i < this.targetColumns.length; ++i) {
            ColumnDefinition targetColumn = this.targetColumns[i];
            if (targetColumn == null || !targetColumn.isPartitionKey()) continue;
            assert (targetColumn.ksName.equals(cfm.ksName) && targetColumn.cfName.equals(cfm.cfName));
            partitionKeyPositions[targetColumn.position()] = (short)i;
        }
        for (Short bindIndex : partitionKeyPositions) {
            if (bindIndex != null) continue;
            return null;
        }
        return partitionKeyPositions;
    }

    public void add(int bindIndex, ColumnSpecification spec) {
        ColumnIdentifier bindMarkerName;
        if (spec instanceof ColumnDefinition) {
            this.targetColumns[bindIndex] = (ColumnDefinition)spec;
        }
        if ((bindMarkerName = this.variableNames.get(bindIndex)) != null) {
            spec = new ColumnSpecification(spec.ksName, spec.cfName, bindMarkerName, spec.type);
        }
        this.specs[bindIndex] = spec;
    }

    public String toString() {
        return Arrays.toString(this.specs);
    }
}

