/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3;

import com.github.cassandra.jdbc.internal.cassandra.config.CFMetaData;
import com.github.cassandra.jdbc.internal.cassandra.config.ColumnDefinition;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnIdentifier;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnSpecification;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Operator;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Relation;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Term;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Tuples;
import com.github.cassandra.jdbc.internal.cassandra.cql3.VariableSpecifications;
import com.github.cassandra.jdbc.internal.cassandra.cql3.restrictions.Restriction;
import com.github.cassandra.jdbc.internal.cassandra.cql3.restrictions.TokenRestriction;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.Bound;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.RequestValidations;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.InvalidRequestException;
import com.github.cassandra.jdbc.internal.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class TokenRelation
extends Relation {
    private final List<ColumnIdentifier.Raw> entities;
    private final Term.Raw value;

    public TokenRelation(List<ColumnIdentifier.Raw> entities, Operator type, Term.Raw value) {
        this.entities = entities;
        this.relationType = type;
        this.value = value;
    }

    @Override
    public boolean onToken() {
        return true;
    }

    @Override
    public Term.Raw getValue() {
        return this.value;
    }

    @Override
    public List<? extends Term.Raw> getInValues() {
        return null;
    }

    @Override
    protected Restriction newEQRestriction(CFMetaData cfm, VariableSpecifications boundNames) throws InvalidRequestException {
        List<ColumnDefinition> columnDefs = this.getColumnDefinitions(cfm);
        Term term = this.toTerm(TokenRelation.toReceivers(cfm, columnDefs), this.value, cfm.ksName, boundNames);
        return new TokenRestriction.EQRestriction(cfm, columnDefs, term);
    }

    @Override
    protected Restriction newINRestriction(CFMetaData cfm, VariableSpecifications boundNames) throws InvalidRequestException {
        throw RequestValidations.invalidRequest("%s cannot be used with the token function", new Object[]{this.operator()});
    }

    @Override
    protected Restriction newSliceRestriction(CFMetaData cfm, VariableSpecifications boundNames, Bound bound, boolean inclusive) throws InvalidRequestException {
        List<ColumnDefinition> columnDefs = this.getColumnDefinitions(cfm);
        Term term = this.toTerm(TokenRelation.toReceivers(cfm, columnDefs), this.value, cfm.ksName, boundNames);
        return new TokenRestriction.SliceRestriction(cfm, columnDefs, bound, inclusive, term);
    }

    @Override
    protected Restriction newContainsRestriction(CFMetaData cfm, VariableSpecifications boundNames, boolean isKey) throws InvalidRequestException {
        throw RequestValidations.invalidRequest("%s cannot be used with the token function", new Object[]{this.operator()});
    }

    @Override
    protected Restriction newIsNotRestriction(CFMetaData cfm, VariableSpecifications boundNames) throws InvalidRequestException {
        throw RequestValidations.invalidRequest("%s cannot be used with the token function", new Object[]{this.operator()});
    }

    @Override
    protected Restriction newLikeRestriction(CFMetaData cfm, VariableSpecifications boundNames, Operator operator) throws InvalidRequestException {
        throw RequestValidations.invalidRequest("%s cannot be used with the token function", new Object[]{operator});
    }

    @Override
    protected Term toTerm(List<? extends ColumnSpecification> receivers, Term.Raw raw, String keyspace, VariableSpecifications boundNames) throws InvalidRequestException {
        Term term = raw.prepare(keyspace, receivers.get(0));
        term.collectMarkerSpecification(boundNames);
        return term;
    }

    @Override
    public Relation renameIdentifier(ColumnIdentifier.Raw from, ColumnIdentifier.Raw to) {
        if (!this.entities.contains(from)) {
            return this;
        }
        List<ColumnIdentifier.Raw> newEntities = this.entities.stream().map(e -> e.equals(from) ? to : e).collect(Collectors.toList());
        return new TokenRelation(newEntities, this.operator(), this.value);
    }

    public String toString() {
        return String.format("token%s %s %s", new Object[]{Tuples.tupleToString(this.entities), this.relationType, this.value});
    }

    private List<ColumnDefinition> getColumnDefinitions(CFMetaData cfm) throws InvalidRequestException {
        ArrayList<ColumnDefinition> columnDefs = new ArrayList<ColumnDefinition>();
        for (ColumnIdentifier.Raw raw : this.entities) {
            columnDefs.add(this.toColumnDefinition(cfm, raw));
        }
        return columnDefs;
    }

    private static List<? extends ColumnSpecification> toReceivers(CFMetaData cfm, List<ColumnDefinition> columnDefs) throws InvalidRequestException {
        if (!columnDefs.equals(cfm.partitionKeyColumns())) {
            RequestValidations.checkTrue(columnDefs.containsAll(cfm.partitionKeyColumns()), "The token() function must be applied to all partition key components or none of them");
            RequestValidations.checkContainsNoDuplicates(columnDefs, "The token() function contains duplicate partition key components");
            RequestValidations.checkContainsOnly(columnDefs, cfm.partitionKeyColumns(), "The token() function must contains only partition key components");
            throw RequestValidations.invalidRequest("The token function arguments must be in the partition key order: %s", Joiner.on(", ").join(ColumnDefinition.toIdentifiers(cfm.partitionKeyColumns())));
        }
        ColumnDefinition firstColumn = columnDefs.get(0);
        return Collections.singletonList(new ColumnSpecification(firstColumn.ksName, firstColumn.cfName, new ColumnIdentifier("partition key token", true), cfm.partitioner.getTokenValidator()));
    }
}

