/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3;

import com.github.cassandra.jdbc.internal.cassandra.db.marshal.AbstractType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.ListType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.MapType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.SetType;
import com.github.cassandra.jdbc.internal.cassandra.utils.ByteBufferUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;

public enum Operator {
    EQ(0){

        @Override
        public String toString() {
            return "=";
        }
    }
    ,
    LT(4){

        @Override
        public String toString() {
            return "<";
        }
    }
    ,
    LTE(3){

        @Override
        public String toString() {
            return "<=";
        }
    }
    ,
    GTE(1){

        @Override
        public String toString() {
            return ">=";
        }
    }
    ,
    GT(2){

        @Override
        public String toString() {
            return ">";
        }
    }
    ,
    IN(7){}
    ,
    CONTAINS(5){}
    ,
    CONTAINS_KEY(6){

        @Override
        public String toString() {
            return "CONTAINS KEY";
        }
    }
    ,
    NEQ(8){

        @Override
        public String toString() {
            return "!=";
        }
    }
    ,
    IS_NOT(9){

        @Override
        public String toString() {
            return "IS NOT";
        }
    }
    ,
    LIKE_PREFIX(10){

        @Override
        public String toString() {
            return "LIKE '<term>%'";
        }
    }
    ,
    LIKE_SUFFIX(11){

        @Override
        public String toString() {
            return "LIKE '%<term>'";
        }
    }
    ,
    LIKE_CONTAINS(12){

        @Override
        public String toString() {
            return "LIKE '%<term>%'";
        }
    }
    ,
    LIKE_MATCHES(13){

        @Override
        public String toString() {
            return "LIKE '<term>'";
        }
    };

    private final int b;

    private Operator(int b) {
        this.b = b;
    }

    public void writeTo(DataOutput output) throws IOException {
        output.writeInt(this.b);
    }

    public int getValue() {
        return this.b;
    }

    public static Operator readFrom(DataInput input) throws IOException {
        int b = input.readInt();
        for (Operator operator : Operator.values()) {
            if (operator.b != b) continue;
            return operator;
        }
        throw new IOException(String.format("Cannot resolve Relation.Type from binary representation: %s", b));
    }

    public boolean isSatisfiedBy(AbstractType<?> type, ByteBuffer leftOperand, ByteBuffer rightOperand) {
        switch (this) {
            case EQ: {
                return type.compareForCQL(leftOperand, rightOperand) == 0;
            }
            case LT: {
                return type.compareForCQL(leftOperand, rightOperand) < 0;
            }
            case LTE: {
                return type.compareForCQL(leftOperand, rightOperand) <= 0;
            }
            case GT: {
                return type.compareForCQL(leftOperand, rightOperand) > 0;
            }
            case GTE: {
                return type.compareForCQL(leftOperand, rightOperand) >= 0;
            }
            case NEQ: {
                return type.compareForCQL(leftOperand, rightOperand) != 0;
            }
            case IN: {
                List inValues = (List)ListType.getInstance(type, false).getSerializer().deserialize(rightOperand);
                return inValues.contains(type.getSerializer().deserialize(leftOperand));
            }
            case CONTAINS: {
                if (type instanceof ListType) {
                    List list = (List)type.getSerializer().deserialize(leftOperand);
                    return list.contains(((ListType)type).getElementsType().getSerializer().deserialize(rightOperand));
                }
                if (type instanceof SetType) {
                    Set set = (Set)type.getSerializer().deserialize(leftOperand);
                    return set.contains(((SetType)type).getElementsType().getSerializer().deserialize(rightOperand));
                }
                Map map = (Map)type.getSerializer().deserialize(leftOperand);
                return map.containsValue(((MapType)type).getValuesType().getSerializer().deserialize(rightOperand));
            }
            case CONTAINS_KEY: {
                Map map = (Map)type.getSerializer().deserialize(leftOperand);
                return map.containsKey(((MapType)type).getKeysType().getSerializer().deserialize(rightOperand));
            }
            case LIKE_PREFIX: {
                return ByteBufferUtil.startsWith(leftOperand, rightOperand);
            }
            case LIKE_SUFFIX: {
                return ByteBufferUtil.endsWith(leftOperand, rightOperand);
            }
            case LIKE_MATCHES: 
            case LIKE_CONTAINS: {
                return ByteBufferUtil.contains(leftOperand, rightOperand);
            }
        }
        throw new AssertionError();
    }

    public int serializedSize() {
        return 4;
    }

    public String toString() {
        return this.name();
    }
}

