/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3;

import com.github.cassandra.jdbc.internal.cassandra.cql3.Operation;
import com.github.cassandra.jdbc.internal.cassandra.cql3.functions.Function;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.StatementType;
import com.github.cassandra.jdbc.internal.google.common.collect.Iterables;
import com.github.cassandra.jdbc.internal.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class Operations
implements Iterable<Operation> {
    private final StatementType type;
    private final List<Operation> regularOperations = new ArrayList<Operation>();
    private final List<Operation> staticOperations = new ArrayList<Operation>();

    public Operations(StatementType type) {
        this.type = type;
    }

    public boolean appliesToStaticColumns() {
        return !this.staticOperations.isEmpty();
    }

    public boolean appliesToRegularColumns() {
        return !this.regularOperations.isEmpty() || this.type.isDelete() && this.staticOperations.isEmpty();
    }

    public List<Operation> regularOperations() {
        return this.regularOperations;
    }

    public List<Operation> staticOperations() {
        return this.staticOperations;
    }

    public void add(Operation operation) {
        if (operation.column.isStatic()) {
            this.staticOperations.add(operation);
        } else {
            this.regularOperations.add(operation);
        }
    }

    public boolean requiresRead() {
        for (Operation operation : this) {
            if (!operation.requiresRead()) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.staticOperations.isEmpty() && this.regularOperations.isEmpty();
    }

    @Override
    public Iterator<Operation> iterator() {
        return Iterators.concat(this.staticOperations.iterator(), this.regularOperations.iterator());
    }

    public Iterable<? extends Function> getFunctions() {
        ArrayList functions = new ArrayList();
        for (Operation operation : this) {
            Iterables.addAll(functions, operation.getFunctions());
        }
        return functions;
    }
}

