/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3;

import com.github.cassandra.jdbc.internal.cassandra.config.ColumnDefinition;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnIdentifier;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnSpecification;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Constants;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Lists;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Maps;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Sets;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Term;
import com.github.cassandra.jdbc.internal.cassandra.cql3.UpdateParameters;
import com.github.cassandra.jdbc.internal.cassandra.cql3.VariableSpecifications;
import com.github.cassandra.jdbc.internal.cassandra.cql3.functions.Function;
import com.github.cassandra.jdbc.internal.cassandra.db.DecoratedKey;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.CollectionType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.CounterColumnType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.ListType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.MapType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.SetType;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.InvalidRequestException;
import java.util.Collections;

public abstract class Operation {
    public final ColumnDefinition column;
    protected final Term t;

    protected Operation(ColumnDefinition column, Term t) {
        assert (column != null);
        this.column = column;
        this.t = t;
    }

    public Iterable<Function> getFunctions() {
        return this.t != null ? this.t.getFunctions() : Collections.emptySet();
    }

    public boolean requiresRead() {
        return false;
    }

    public void collectMarkerSpecification(VariableSpecifications boundNames) {
        if (this.t != null) {
            this.t.collectMarkerSpecification(boundNames);
        }
    }

    public abstract void execute(DecoratedKey var1, UpdateParameters var2) throws InvalidRequestException;

    public static class ElementDeletion
    implements RawDeletion {
        private final ColumnIdentifier.Raw id;
        private final Term.Raw element;

        public ElementDeletion(ColumnIdentifier.Raw id, Term.Raw element) {
            this.id = id;
            this.element = element;
        }

        @Override
        public ColumnIdentifier.Raw affectedColumn() {
            return this.id;
        }

        @Override
        public Operation prepare(String keyspace, ColumnDefinition receiver) throws InvalidRequestException {
            if (!receiver.type.isCollection()) {
                throw new InvalidRequestException(String.format("Invalid deletion operation for non collection column %s", receiver.name));
            }
            if (!receiver.type.isMultiCell()) {
                throw new InvalidRequestException(String.format("Invalid deletion operation for frozen collection column %s", receiver.name));
            }
            switch (((CollectionType)receiver.type).kind) {
                case LIST: {
                    Term idx = this.element.prepare(keyspace, Lists.indexSpecOf(receiver));
                    return new Lists.DiscarderByIndex(receiver, idx);
                }
                case SET: {
                    Term elt = this.element.prepare(keyspace, Sets.valueSpecOf(receiver));
                    return new Sets.ElementDiscarder(receiver, elt);
                }
                case MAP: {
                    Term key = this.element.prepare(keyspace, Maps.keySpecOf(receiver));
                    return new Maps.DiscarderByKey(receiver, key);
                }
            }
            throw new AssertionError();
        }
    }

    public static class ColumnDeletion
    implements RawDeletion {
        private final ColumnIdentifier.Raw id;

        public ColumnDeletion(ColumnIdentifier.Raw id) {
            this.id = id;
        }

        @Override
        public ColumnIdentifier.Raw affectedColumn() {
            return this.id;
        }

        @Override
        public Operation prepare(String keyspace, ColumnDefinition receiver) throws InvalidRequestException {
            return new Constants.Deleter(receiver);
        }
    }

    public static class Prepend
    implements RawUpdate {
        private final Term.Raw value;

        public Prepend(Term.Raw value) {
            this.value = value;
        }

        @Override
        public Operation prepare(String keyspace, ColumnDefinition receiver) throws InvalidRequestException {
            Term v = this.value.prepare(keyspace, receiver);
            if (!(receiver.type instanceof ListType)) {
                throw new InvalidRequestException(String.format("Invalid operation (%s) for non list column %s", this.toString(receiver), receiver.name));
            }
            if (!receiver.type.isMultiCell()) {
                throw new InvalidRequestException(String.format("Invalid operation (%s) for frozen list column %s", this.toString(receiver), receiver.name));
            }
            return new Lists.Prepender(receiver, v);
        }

        protected String toString(ColumnSpecification column) {
            return String.format("%s = %s - %s", column.name, this.value, column.name);
        }

        @Override
        public boolean isCompatibleWith(RawUpdate other) {
            return !(other instanceof SetValue);
        }
    }

    public static class Substraction
    implements RawUpdate {
        private final Term.Raw value;

        public Substraction(Term.Raw value) {
            this.value = value;
        }

        @Override
        public Operation prepare(String keyspace, ColumnDefinition receiver) throws InvalidRequestException {
            if (!(receiver.type instanceof CollectionType)) {
                if (!(receiver.type instanceof CounterColumnType)) {
                    throw new InvalidRequestException(String.format("Invalid operation (%s) for non counter column %s", this.toString(receiver), receiver.name));
                }
                return new Constants.Substracter(receiver, this.value.prepare(keyspace, receiver));
            }
            if (!receiver.type.isMultiCell()) {
                throw new InvalidRequestException(String.format("Invalid operation (%s) for frozen collection column %s", this.toString(receiver), receiver.name));
            }
            switch (((CollectionType)receiver.type).kind) {
                case LIST: {
                    return new Lists.Discarder(receiver, this.value.prepare(keyspace, receiver));
                }
                case SET: {
                    return new Sets.Discarder(receiver, this.value.prepare(keyspace, receiver));
                }
                case MAP: {
                    ColumnSpecification vr = new ColumnSpecification(receiver.ksName, receiver.cfName, receiver.name, SetType.getInstance(((MapType)receiver.type).getKeysType(), false));
                    return new Sets.Discarder(receiver, this.value.prepare(keyspace, vr));
                }
            }
            throw new AssertionError();
        }

        protected String toString(ColumnSpecification column) {
            return String.format("%s = %s - %s", column.name, column.name, this.value);
        }

        @Override
        public boolean isCompatibleWith(RawUpdate other) {
            return !(other instanceof SetValue);
        }
    }

    public static class Addition
    implements RawUpdate {
        private final Term.Raw value;

        public Addition(Term.Raw value) {
            this.value = value;
        }

        @Override
        public Operation prepare(String keyspace, ColumnDefinition receiver) throws InvalidRequestException {
            Term v = this.value.prepare(keyspace, receiver);
            if (!(receiver.type instanceof CollectionType)) {
                if (!(receiver.type instanceof CounterColumnType)) {
                    throw new InvalidRequestException(String.format("Invalid operation (%s) for non counter column %s", this.toString(receiver), receiver.name));
                }
                return new Constants.Adder(receiver, v);
            }
            if (!receiver.type.isMultiCell()) {
                throw new InvalidRequestException(String.format("Invalid operation (%s) for frozen collection column %s", this.toString(receiver), receiver.name));
            }
            switch (((CollectionType)receiver.type).kind) {
                case LIST: {
                    return new Lists.Appender(receiver, v);
                }
                case SET: {
                    return new Sets.Adder(receiver, v);
                }
                case MAP: {
                    return new Maps.Putter(receiver, v);
                }
            }
            throw new AssertionError();
        }

        protected String toString(ColumnSpecification column) {
            return String.format("%s = %s + %s", column.name, column.name, this.value);
        }

        @Override
        public boolean isCompatibleWith(RawUpdate other) {
            return !(other instanceof SetValue);
        }
    }

    public static class SetElement
    implements RawUpdate {
        private final Term.Raw selector;
        private final Term.Raw value;

        public SetElement(Term.Raw selector, Term.Raw value) {
            this.selector = selector;
            this.value = value;
        }

        @Override
        public Operation prepare(String keyspace, ColumnDefinition receiver) throws InvalidRequestException {
            if (!(receiver.type instanceof CollectionType)) {
                throw new InvalidRequestException(String.format("Invalid operation (%s) for non collection column %s", this.toString(receiver), receiver.name));
            }
            if (!receiver.type.isMultiCell()) {
                throw new InvalidRequestException(String.format("Invalid operation (%s) for frozen collection column %s", this.toString(receiver), receiver.name));
            }
            switch (((CollectionType)receiver.type).kind) {
                case LIST: {
                    Term idx = this.selector.prepare(keyspace, Lists.indexSpecOf(receiver));
                    Term lval = this.value.prepare(keyspace, Lists.valueSpecOf(receiver));
                    return new Lists.SetterByIndex(receiver, idx, lval);
                }
                case SET: {
                    throw new InvalidRequestException(String.format("Invalid operation (%s) for set column %s", this.toString(receiver), receiver.name));
                }
                case MAP: {
                    Term key = this.selector.prepare(keyspace, Maps.keySpecOf(receiver));
                    Term mval = this.value.prepare(keyspace, Maps.valueSpecOf(receiver));
                    return new Maps.SetterByKey(receiver, key, mval);
                }
            }
            throw new AssertionError();
        }

        protected String toString(ColumnSpecification column) {
            return String.format("%s[%s] = %s", column.name, this.selector, this.value);
        }

        @Override
        public boolean isCompatibleWith(RawUpdate other) {
            return !(other instanceof SetValue);
        }
    }

    public static class SetValue
    implements RawUpdate {
        private final Term.Raw value;

        public SetValue(Term.Raw value) {
            this.value = value;
        }

        @Override
        public Operation prepare(String keyspace, ColumnDefinition receiver) throws InvalidRequestException {
            Term v = this.value.prepare(keyspace, receiver);
            if (receiver.type instanceof CounterColumnType) {
                throw new InvalidRequestException(String.format("Cannot set the value of counter column %s (counters can only be incremented/decremented, not set)", receiver.name));
            }
            if (!receiver.type.isCollection()) {
                return new Constants.Setter(receiver, v);
            }
            switch (((CollectionType)receiver.type).kind) {
                case LIST: {
                    return new Lists.Setter(receiver, v);
                }
                case SET: {
                    return new Sets.Setter(receiver, v);
                }
                case MAP: {
                    return new Maps.Setter(receiver, v);
                }
            }
            throw new AssertionError();
        }

        protected String toString(ColumnSpecification column) {
            return String.format("%s = %s", column, this.value);
        }

        @Override
        public boolean isCompatibleWith(RawUpdate other) {
            return false;
        }
    }

    public static interface RawDeletion {
        public ColumnIdentifier.Raw affectedColumn();

        public Operation prepare(String var1, ColumnDefinition var2) throws InvalidRequestException;
    }

    public static interface RawUpdate {
        public Operation prepare(String var1, ColumnDefinition var2) throws InvalidRequestException;

        public boolean isCompatibleWith(RawUpdate var1);
    }
}

