/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3;

import com.github.cassandra.jdbc.internal.cassandra.config.CFMetaData;
import com.github.cassandra.jdbc.internal.cassandra.config.ColumnDefinition;
import com.github.cassandra.jdbc.internal.cassandra.cql3.AbstractMarker;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnIdentifier;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnSpecification;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Operator;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Relation;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Term;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Tuples;
import com.github.cassandra.jdbc.internal.cassandra.cql3.VariableSpecifications;
import com.github.cassandra.jdbc.internal.cassandra.cql3.restrictions.MultiColumnRestriction;
import com.github.cassandra.jdbc.internal.cassandra.cql3.restrictions.Restriction;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.Bound;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.RequestValidations;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.InvalidRequestException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class MultiColumnRelation
extends Relation {
    private final List<ColumnIdentifier.Raw> entities;
    private final Term.MultiColumnRaw valuesOrMarker;
    private final List<? extends Term.MultiColumnRaw> inValues;
    private final Tuples.INRaw inMarker;

    private MultiColumnRelation(List<ColumnIdentifier.Raw> entities, Operator relationType, Term.MultiColumnRaw valuesOrMarker, List<? extends Term.MultiColumnRaw> inValues, Tuples.INRaw inMarker) {
        this.entities = entities;
        this.relationType = relationType;
        this.valuesOrMarker = valuesOrMarker;
        this.inValues = inValues;
        this.inMarker = inMarker;
    }

    public static MultiColumnRelation createNonInRelation(List<ColumnIdentifier.Raw> entities, Operator relationType, Term.MultiColumnRaw valuesOrMarker) {
        assert (relationType != Operator.IN);
        return new MultiColumnRelation(entities, relationType, valuesOrMarker, null, null);
    }

    public static MultiColumnRelation createInRelation(List<ColumnIdentifier.Raw> entities, List<? extends Term.MultiColumnRaw> inValues) {
        return new MultiColumnRelation(entities, Operator.IN, null, inValues, null);
    }

    public static MultiColumnRelation createSingleMarkerInRelation(List<ColumnIdentifier.Raw> entities, Tuples.INRaw inMarker) {
        return new MultiColumnRelation(entities, Operator.IN, null, null, inMarker);
    }

    public List<ColumnIdentifier.Raw> getEntities() {
        return this.entities;
    }

    @Override
    public Term.MultiColumnRaw getValue() {
        return this.relationType == Operator.IN ? this.inMarker : this.valuesOrMarker;
    }

    @Override
    public List<? extends Term.Raw> getInValues() {
        assert (this.relationType == Operator.IN);
        return this.inValues;
    }

    @Override
    public boolean isMultiColumn() {
        return true;
    }

    @Override
    protected Restriction newEQRestriction(CFMetaData cfm, VariableSpecifications boundNames) throws InvalidRequestException {
        List<ColumnDefinition> receivers = this.receivers(cfm);
        Term term = this.toTerm(receivers, this.getValue(), cfm.ksName, boundNames);
        return new MultiColumnRestriction.EQRestriction(receivers, term);
    }

    @Override
    protected Restriction newINRestriction(CFMetaData cfm, VariableSpecifications boundNames) throws InvalidRequestException {
        List<ColumnDefinition> receivers = this.receivers(cfm);
        List<Term> terms = this.toTerms(receivers, this.inValues, cfm.ksName, boundNames);
        if (terms == null) {
            Term term = this.toTerm(receivers, this.getValue(), cfm.ksName, boundNames);
            return new MultiColumnRestriction.InRestrictionWithMarker(receivers, (AbstractMarker)term);
        }
        return new MultiColumnRestriction.InRestrictionWithValues(receivers, terms);
    }

    @Override
    protected Restriction newSliceRestriction(CFMetaData cfm, VariableSpecifications boundNames, Bound bound, boolean inclusive) throws InvalidRequestException {
        List<ColumnDefinition> receivers = this.receivers(cfm);
        Term term = this.toTerm(this.receivers(cfm), this.getValue(), cfm.ksName, boundNames);
        return new MultiColumnRestriction.SliceRestriction(receivers, bound, inclusive, term);
    }

    @Override
    protected Restriction newContainsRestriction(CFMetaData cfm, VariableSpecifications boundNames, boolean isKey) throws InvalidRequestException {
        throw RequestValidations.invalidRequest("%s cannot be used for multi-column relations", new Object[]{this.operator()});
    }

    @Override
    protected Restriction newIsNotRestriction(CFMetaData cfm, VariableSpecifications boundNames) throws InvalidRequestException {
        throw new AssertionError((Object)String.format("%s cannot be used for multi-column relations", new Object[]{this.operator()}));
    }

    @Override
    protected Restriction newLikeRestriction(CFMetaData cfm, VariableSpecifications boundNames, Operator operator) throws InvalidRequestException {
        throw RequestValidations.invalidRequest("%s cannot be used for multi-column relations", new Object[]{this.operator()});
    }

    @Override
    protected Term toTerm(List<? extends ColumnSpecification> receivers, Term.Raw raw, String keyspace, VariableSpecifications boundNames) throws InvalidRequestException {
        Term term = ((Term.MultiColumnRaw)raw).prepare(keyspace, receivers);
        term.collectMarkerSpecification(boundNames);
        return term;
    }

    protected List<ColumnDefinition> receivers(CFMetaData cfm) throws InvalidRequestException {
        ArrayList<ColumnDefinition> names = new ArrayList<ColumnDefinition>(this.getEntities().size());
        int previousPosition = -1;
        for (ColumnIdentifier.Raw raw : this.getEntities()) {
            ColumnDefinition def = this.toColumnDefinition(cfm, raw);
            RequestValidations.checkTrue(def.isClusteringColumn(), "Multi-column relations can only be applied to clustering columns but was applied to: %s", def.name);
            RequestValidations.checkFalse(names.contains(def), "Column \"%s\" appeared twice in a relation: %s", def.name, this);
            RequestValidations.checkFalse(previousPosition != -1 && def.position() != previousPosition + 1, "Clustering columns must appear in the PRIMARY KEY order in multi-column relations: %s", this);
            names.add(def);
            previousPosition = def.position();
        }
        return names;
    }

    @Override
    public Relation renameIdentifier(ColumnIdentifier.Raw from, ColumnIdentifier.Raw to) {
        if (!this.entities.contains(from)) {
            return this;
        }
        List<ColumnIdentifier.Raw> newEntities = this.entities.stream().map(e -> e.equals(from) ? to : e).collect(Collectors.toList());
        return new MultiColumnRelation(newEntities, this.operator(), this.valuesOrMarker, this.inValues, this.inMarker);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(Tuples.tupleToString(this.entities));
        if (this.isIN()) {
            return builder.append(" IN ").append(this.inMarker != null ? Character.valueOf('?') : Tuples.tupleToString(this.inValues)).toString();
        }
        return builder.append(" ").append((Object)this.relationType).append(" ").append(this.valuesOrMarker).toString();
    }
}

