/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3;

import com.github.cassandra.jdbc.internal.cassandra.config.ColumnDefinition;
import com.github.cassandra.jdbc.internal.cassandra.cql3.AbstractMarker;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnSpecification;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Lists;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Maps;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Operator;
import com.github.cassandra.jdbc.internal.cassandra.cql3.QueryOptions;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Sets;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Term;
import com.github.cassandra.jdbc.internal.cassandra.cql3.VariableSpecifications;
import com.github.cassandra.jdbc.internal.cassandra.cql3.functions.Function;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.AbstractType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.CollectionType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.CounterColumnType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.ListType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.MapType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.SetType;
import com.github.cassandra.jdbc.internal.cassandra.db.rows.Cell;
import com.github.cassandra.jdbc.internal.cassandra.db.rows.CellPath;
import com.github.cassandra.jdbc.internal.cassandra.db.rows.ComplexColumnData;
import com.github.cassandra.jdbc.internal.cassandra.db.rows.Row;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.InvalidRequestException;
import com.github.cassandra.jdbc.internal.cassandra.serializers.ListSerializer;
import com.github.cassandra.jdbc.internal.cassandra.serializers.MapSerializer;
import com.github.cassandra.jdbc.internal.cassandra.utils.ByteBufferUtil;
import com.github.cassandra.jdbc.internal.google.common.collect.Iterables;
import com.github.cassandra.jdbc.internal.google.common.collect.Iterators;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;

public class ColumnCondition {
    public final ColumnDefinition column;
    private final Term collectionElement;
    private final Term value;
    private final List<Term> inValues;
    public final Operator operator;

    private ColumnCondition(ColumnDefinition column, Term collectionElement, Term value, List<Term> inValues, Operator op) {
        this.column = column;
        this.collectionElement = collectionElement;
        this.value = value;
        this.inValues = inValues;
        this.operator = op;
        if (this.operator != Operator.IN) assert (this.inValues == null);
    }

    public static ColumnCondition condition(ColumnDefinition column, Term value, Operator op) {
        return new ColumnCondition(column, null, value, null, op);
    }

    public static ColumnCondition condition(ColumnDefinition column, Term collectionElement, Term value, Operator op) {
        return new ColumnCondition(column, collectionElement, value, null, op);
    }

    public static ColumnCondition inCondition(ColumnDefinition column, List<Term> inValues) {
        return new ColumnCondition(column, null, null, inValues, Operator.IN);
    }

    public static ColumnCondition inCondition(ColumnDefinition column, Term collectionElement, List<Term> inValues) {
        return new ColumnCondition(column, collectionElement, null, inValues, Operator.IN);
    }

    public static ColumnCondition inCondition(ColumnDefinition column, Term inMarker) {
        return new ColumnCondition(column, null, inMarker, null, Operator.IN);
    }

    public static ColumnCondition inCondition(ColumnDefinition column, Term collectionElement, Term inMarker) {
        return new ColumnCondition(column, collectionElement, inMarker, null, Operator.IN);
    }

    public Iterable<Function> getFunctions() {
        Iterable<Object> iter = Collections.emptyList();
        if (this.collectionElement != null) {
            iter = Iterables.concat(iter, this.collectionElement.getFunctions());
        }
        if (this.value != null) {
            iter = Iterables.concat(iter, this.value.getFunctions());
        }
        if (this.inValues != null) {
            for (Term value : this.inValues) {
                if (value == null) continue;
                iter = Iterables.concat(iter, value.getFunctions());
            }
        }
        return iter;
    }

    public void collectMarkerSpecification(VariableSpecifications boundNames) {
        if (this.collectionElement != null) {
            this.collectionElement.collectMarkerSpecification(boundNames);
        }
        if (this.operator == Operator.IN && this.inValues != null) {
            for (Term value : this.inValues) {
                value.collectMarkerSpecification(boundNames);
            }
        } else {
            this.value.collectMarkerSpecification(boundNames);
        }
    }

    public Bound bind(QueryOptions options) throws InvalidRequestException {
        boolean isInCondition;
        boolean bl = isInCondition = this.operator == Operator.IN;
        if (this.column.type instanceof CollectionType) {
            if (this.collectionElement == null) {
                return isInCondition ? new CollectionInBound(this, options) : new CollectionBound(this, options);
            }
            return isInCondition ? new ElementAccessInBound(this, options) : new ElementAccessBound(this, options);
        }
        return isInCondition ? new SimpleInBound(this, options) : new SimpleBound(this, options);
    }

    private static Cell getCell(Row row, ColumnDefinition column) {
        return row == null ? null : row.getCell(column);
    }

    private static Cell getCell(Row row, ColumnDefinition column, CellPath path) {
        return row == null ? null : row.getCell(column, path);
    }

    private static Iterator<Cell> getCells(Row row, ColumnDefinition column) {
        if (row == null) {
            return Collections.emptyIterator();
        }
        ComplexColumnData complexData = row.getComplexColumnData(column);
        return complexData == null ? Collections.emptyIterator() : complexData.iterator();
    }

    public static class Raw {
        private final Term.Raw value;
        private final List<Term.Raw> inValues;
        private final AbstractMarker.INRaw inMarker;
        private final Term.Raw collectionElement;
        private final Operator operator;

        private Raw(Term.Raw value, List<Term.Raw> inValues, AbstractMarker.INRaw inMarker, Term.Raw collectionElement, Operator op) {
            this.value = value;
            this.inValues = inValues;
            this.inMarker = inMarker;
            this.collectionElement = collectionElement;
            this.operator = op;
        }

        public static Raw simpleCondition(Term.Raw value, Operator op) {
            return new Raw(value, null, null, null, op);
        }

        public static Raw simpleInCondition(List<Term.Raw> inValues) {
            return new Raw(null, inValues, null, null, Operator.IN);
        }

        public static Raw simpleInCondition(AbstractMarker.INRaw inMarker) {
            return new Raw(null, null, inMarker, null, Operator.IN);
        }

        public static Raw collectionCondition(Term.Raw value, Term.Raw collectionElement, Operator op) {
            return new Raw(value, null, null, collectionElement, op);
        }

        public static Raw collectionInCondition(Term.Raw collectionElement, List<Term.Raw> inValues) {
            return new Raw(null, inValues, null, collectionElement, Operator.IN);
        }

        public static Raw collectionInCondition(Term.Raw collectionElement, AbstractMarker.INRaw inMarker) {
            return new Raw(null, null, inMarker, collectionElement, Operator.IN);
        }

        public ColumnCondition prepare(String keyspace, ColumnDefinition receiver) throws InvalidRequestException {
            ColumnSpecification valueSpec;
            ColumnSpecification elementSpec;
            if (receiver.type instanceof CounterColumnType) {
                throw new InvalidRequestException("Conditions on counters are not supported");
            }
            if (this.collectionElement == null) {
                if (this.operator == Operator.IN) {
                    if (this.inValues == null) {
                        return ColumnCondition.inCondition(receiver, this.inMarker.prepare(keyspace, receiver));
                    }
                    ArrayList<Term> terms = new ArrayList<Term>(this.inValues.size());
                    for (Term.Raw value : this.inValues) {
                        terms.add(value.prepare(keyspace, receiver));
                    }
                    return ColumnCondition.inCondition(receiver, terms);
                }
                return ColumnCondition.condition(receiver, this.value.prepare(keyspace, receiver), this.operator);
            }
            if (!receiver.type.isCollection()) {
                throw new InvalidRequestException(String.format("Invalid element access syntax for non-collection column %s", receiver.name));
            }
            switch (((CollectionType)receiver.type).kind) {
                case LIST: {
                    elementSpec = Lists.indexSpecOf(receiver);
                    valueSpec = Lists.valueSpecOf(receiver);
                    break;
                }
                case MAP: {
                    elementSpec = Maps.keySpecOf(receiver);
                    valueSpec = Maps.valueSpecOf(receiver);
                    break;
                }
                case SET: {
                    throw new InvalidRequestException(String.format("Invalid element access syntax for set column %s", receiver.name));
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (this.operator == Operator.IN) {
                if (this.inValues == null) {
                    return ColumnCondition.inCondition(receiver, this.collectionElement.prepare(keyspace, elementSpec), this.inMarker.prepare(keyspace, valueSpec));
                }
                ArrayList<Term> terms = new ArrayList<Term>(this.inValues.size());
                for (Term.Raw value : this.inValues) {
                    terms.add(value.prepare(keyspace, valueSpec));
                }
                return ColumnCondition.inCondition(receiver, this.collectionElement.prepare(keyspace, elementSpec), terms);
            }
            return ColumnCondition.condition(receiver, this.collectionElement.prepare(keyspace, elementSpec), this.value.prepare(keyspace, valueSpec), this.operator);
        }
    }

    public static class CollectionInBound
    extends Bound {
        private final List<Term.Terminal> inValues;

        private CollectionInBound(ColumnCondition condition, QueryOptions options) throws InvalidRequestException {
            block11: {
                block9: {
                    Lists.Marker inValuesMarker;
                    CollectionType collectionType;
                    block12: {
                        block10: {
                            super(condition.column, condition.operator);
                            assert (this.column.type instanceof CollectionType && condition.collectionElement == null);
                            assert (condition.operator == Operator.IN);
                            this.inValues = new ArrayList<Term.Terminal>();
                            if (condition.inValues != null) break block9;
                            collectionType = (CollectionType)this.column.type;
                            inValuesMarker = (Lists.Marker)condition.value;
                            if (!(this.column.type instanceof ListType)) break block10;
                            ListType<?> deserializer = ListType.getInstance(collectionType.valueComparator(), false);
                            for (ByteBuffer buffer : ((Lists.Value)inValuesMarker.bind((QueryOptions)options)).elements) {
                                if (buffer == null) {
                                    this.inValues.add(null);
                                    continue;
                                }
                                this.inValues.add(Lists.Value.fromSerialized(buffer, deserializer, options.getProtocolVersion()));
                            }
                            break block11;
                        }
                        if (!(this.column.type instanceof MapType)) break block12;
                        MapType<?, ?> deserializer = MapType.getInstance(collectionType.nameComparator(), collectionType.valueComparator(), false);
                        for (ByteBuffer buffer : ((Lists.Value)inValuesMarker.bind((QueryOptions)options)).elements) {
                            if (buffer == null) {
                                this.inValues.add(null);
                                continue;
                            }
                            this.inValues.add(Maps.Value.fromSerialized(buffer, deserializer, options.getProtocolVersion()));
                        }
                        break block11;
                    }
                    if (!(this.column.type instanceof SetType)) break block11;
                    SetType<?> deserializer = SetType.getInstance(collectionType.valueComparator(), false);
                    for (ByteBuffer buffer : ((Lists.Value)inValuesMarker.bind((QueryOptions)options)).elements) {
                        if (buffer == null) {
                            this.inValues.add(null);
                            continue;
                        }
                        this.inValues.add(Sets.Value.fromSerialized(buffer, deserializer, options.getProtocolVersion()));
                    }
                    break block11;
                }
                for (Term value : condition.inValues) {
                    this.inValues.add(value.bind(options));
                }
            }
        }

        @Override
        public boolean appliesTo(Row row) throws InvalidRequestException {
            CollectionType type = (CollectionType)this.column.type;
            if (type.isMultiCell()) {
                for (Term.Terminal value : this.inValues) {
                    if (!CollectionBound.valueAppliesTo(type, ColumnCondition.getCells(row, this.column), value, Operator.EQ)) continue;
                    return true;
                }
                return false;
            }
            Cell cell = ColumnCondition.getCell(row, this.column);
            for (Term.Terminal value : this.inValues) {
                if (!(value == null ? cell == null : type.compare(value.get(3), cell.value()) == 0)) continue;
                return true;
            }
            return false;
        }
    }

    static class CollectionBound
    extends Bound {
        private final Term.Terminal value;

        private CollectionBound(ColumnCondition condition, QueryOptions options) throws InvalidRequestException {
            super(condition.column, condition.operator);
            assert (this.column.type.isCollection() && condition.collectionElement == null);
            assert (condition.operator != Operator.IN);
            this.value = condition.value.bind(options);
        }

        @Override
        public boolean appliesTo(Row row) throws InvalidRequestException {
            CollectionType type = (CollectionType)this.column.type;
            if (type.isMultiCell()) {
                Iterator iter = ColumnCondition.getCells(row, this.column);
                if (this.value == null) {
                    if (this.operator == Operator.EQ) {
                        return !iter.hasNext();
                    }
                    if (this.operator == Operator.NEQ) {
                        return iter.hasNext();
                    }
                    throw new InvalidRequestException(String.format("Invalid comparison with null for operator \"%s\"", new Object[]{this.operator}));
                }
                return CollectionBound.valueAppliesTo(type, iter, this.value, this.operator);
            }
            Cell cell = ColumnCondition.getCell(row, this.column);
            if (this.value == null) {
                if (this.operator == Operator.EQ) {
                    return cell == null;
                }
                if (this.operator == Operator.NEQ) {
                    return cell != null;
                }
                throw new InvalidRequestException(String.format("Invalid comparison with null for operator \"%s\"", new Object[]{this.operator}));
            }
            ByteBuffer conditionValue = type.kind == CollectionType.Kind.LIST ? ((Lists.Value)this.value).get(3) : (type.kind == CollectionType.Kind.SET ? ((Sets.Value)this.value).get(3) : ((Maps.Value)this.value).get(3));
            return this.compareWithOperator(this.operator, type, conditionValue, cell.value());
        }

        static boolean valueAppliesTo(CollectionType type, Iterator<Cell> iter, Term.Terminal value, Operator operator) {
            if (value == null) {
                return !iter.hasNext();
            }
            switch (type.kind) {
                case LIST: {
                    List<ByteBuffer> valueList = ((Lists.Value)value).elements;
                    return CollectionBound.listAppliesTo((ListType)type, iter, valueList, operator);
                }
                case SET: {
                    SortedSet<ByteBuffer> valueSet = ((Sets.Value)value).elements;
                    return CollectionBound.setAppliesTo((SetType)type, iter, valueSet, operator);
                }
                case MAP: {
                    Map<ByteBuffer, ByteBuffer> valueMap = ((Maps.Value)value).map;
                    return CollectionBound.mapAppliesTo((MapType)type, iter, valueMap, operator);
                }
            }
            throw new AssertionError();
        }

        private static boolean setOrListAppliesTo(AbstractType<?> type, Iterator<Cell> iter, Iterator<ByteBuffer> conditionIter, Operator operator, boolean isSet) {
            while (iter.hasNext()) {
                if (!conditionIter.hasNext()) {
                    return operator == Operator.GT || operator == Operator.GTE || operator == Operator.NEQ;
                }
                ByteBuffer cellValue = isSet ? iter.next().path().get(0) : iter.next().value();
                int comparison = type.compare(cellValue, conditionIter.next());
                if (comparison == 0) continue;
                return CollectionBound.evaluateComparisonWithOperator(comparison, operator);
            }
            if (conditionIter.hasNext()) {
                return operator == Operator.LT || operator == Operator.LTE || operator == Operator.NEQ;
            }
            return operator == Operator.EQ || operator == Operator.LTE || operator == Operator.GTE;
        }

        private static boolean evaluateComparisonWithOperator(int comparison, Operator operator) {
            switch (operator) {
                case EQ: {
                    return false;
                }
                case LT: 
                case LTE: {
                    return comparison < 0;
                }
                case GT: 
                case GTE: {
                    return comparison > 0;
                }
                case NEQ: {
                    return true;
                }
            }
            throw new AssertionError();
        }

        static boolean listAppliesTo(ListType type, Iterator<Cell> iter, List<ByteBuffer> elements, Operator operator) {
            return CollectionBound.setOrListAppliesTo(type.getElementsType(), iter, elements.iterator(), operator, false);
        }

        static boolean setAppliesTo(SetType type, Iterator<Cell> iter, Set<ByteBuffer> elements, Operator operator) {
            ArrayList<ByteBuffer> sortedElements = new ArrayList<ByteBuffer>(elements.size());
            sortedElements.addAll(elements);
            Collections.sort(sortedElements, type.getElementsType());
            return CollectionBound.setOrListAppliesTo(type.getElementsType(), iter, sortedElements.iterator(), operator, true);
        }

        static boolean mapAppliesTo(MapType type, Iterator<Cell> iter, Map<ByteBuffer, ByteBuffer> elements, Operator operator) {
            Iterator<Map.Entry<ByteBuffer, ByteBuffer>> conditionIter = elements.entrySet().iterator();
            while (iter.hasNext()) {
                if (!conditionIter.hasNext()) {
                    return operator == Operator.GT || operator == Operator.GTE || operator == Operator.NEQ;
                }
                Map.Entry<ByteBuffer, ByteBuffer> conditionEntry = conditionIter.next();
                Cell c = iter.next();
                int comparison = type.getKeysType().compare(c.path().get(0), conditionEntry.getKey());
                if (comparison != 0) {
                    return CollectionBound.evaluateComparisonWithOperator(comparison, operator);
                }
                comparison = type.getValuesType().compare(c.value(), conditionEntry.getValue());
                if (comparison == 0) continue;
                return CollectionBound.evaluateComparisonWithOperator(comparison, operator);
            }
            if (conditionIter.hasNext()) {
                return operator == Operator.LT || operator == Operator.LTE || operator == Operator.NEQ;
            }
            return operator == Operator.EQ || operator == Operator.LTE || operator == Operator.GTE;
        }
    }

    static class ElementAccessInBound
    extends Bound {
        public final ByteBuffer collectionElement;
        public final List<ByteBuffer> inValues;

        private ElementAccessInBound(ColumnCondition condition, QueryOptions options) throws InvalidRequestException {
            super(condition.column, condition.operator);
            assert (this.column.type instanceof CollectionType && condition.collectionElement != null);
            this.collectionElement = condition.collectionElement.bindAndGet(options);
            if (condition.inValues == null) {
                this.inValues = ((Lists.Value)condition.value.bind(options)).getElements();
            } else {
                this.inValues = new ArrayList<ByteBuffer>(condition.inValues.size());
                for (Term value : condition.inValues) {
                    this.inValues.add(value.bindAndGet(options));
                }
            }
        }

        @Override
        public boolean appliesTo(Row row) throws InvalidRequestException {
            if (this.collectionElement == null) {
                throw new InvalidRequestException("Invalid null value for " + (this.column.type instanceof MapType ? "map" : "list") + " element access");
            }
            if (this.column.type instanceof MapType) {
                MapType mapType = (MapType)this.column.type;
                AbstractType valueType = mapType.getValuesType();
                if (this.column.type.isMultiCell()) {
                    Cell item = ColumnCondition.getCell(row, this.column, CellPath.create((ByteBuffer)this.collectionElement));
                    for (ByteBuffer value : this.inValues) {
                        if (!this.isSatisfiedByValue(value, item, valueType, Operator.EQ)) continue;
                        return true;
                    }
                    return false;
                }
                Cell cell = ColumnCondition.getCell(row, this.column);
                ByteBuffer mapElementValue = cell == null ? null : ((MapSerializer)mapType.getSerializer()).getSerializedValue(cell.value(), this.collectionElement, mapType.getKeysType());
                for (ByteBuffer value : this.inValues) {
                    if (!(value == null ? mapElementValue == null : valueType.compare(value, mapElementValue) == 0)) continue;
                    return true;
                }
                return false;
            }
            ListType listType = (ListType)this.column.type;
            AbstractType elementsType = listType.getElementsType();
            if (this.column.type.isMultiCell()) {
                ByteBuffer columnValue = ElementAccessBound.getListItem(ColumnCondition.getCells(row, this.column), ElementAccessBound.getListIndex(this.collectionElement));
                for (ByteBuffer value : this.inValues) {
                    if (!this.compareWithOperator(Operator.EQ, elementsType, value, columnValue)) continue;
                    return true;
                }
            } else {
                Cell cell = ColumnCondition.getCell(row, this.column);
                ByteBuffer listElementValue = cell == null ? null : ((ListSerializer)listType.getSerializer()).getElement(cell.value(), ElementAccessBound.getListIndex(this.collectionElement));
                for (ByteBuffer value : this.inValues) {
                    if (!(value == null ? listElementValue == null : elementsType.compare(value, listElementValue) == 0)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    static class ElementAccessBound
    extends Bound {
        public final ByteBuffer collectionElement;
        public final ByteBuffer value;

        private ElementAccessBound(ColumnCondition condition, QueryOptions options) throws InvalidRequestException {
            super(condition.column, condition.operator);
            assert (this.column.type instanceof CollectionType && condition.collectionElement != null);
            assert (condition.operator != Operator.IN);
            this.collectionElement = condition.collectionElement.bindAndGet(options);
            this.value = condition.value.bindAndGet(options);
        }

        @Override
        public boolean appliesTo(Row row) throws InvalidRequestException {
            if (this.collectionElement == null) {
                throw new InvalidRequestException("Invalid null value for " + (this.column.type instanceof MapType ? "map" : "list") + " element access");
            }
            if (this.column.type instanceof MapType) {
                MapType mapType = (MapType)this.column.type;
                if (this.column.type.isMultiCell()) {
                    Cell cell = ColumnCondition.getCell(row, this.column, CellPath.create((ByteBuffer)this.collectionElement));
                    return this.isSatisfiedByValue(this.value, cell, ((MapType)this.column.type).getValuesType(), this.operator);
                }
                Cell cell = ColumnCondition.getCell(row, this.column);
                ByteBuffer mapElementValue = ((MapSerializer)mapType.getSerializer()).getSerializedValue(cell.value(), this.collectionElement, mapType.getKeysType());
                return this.compareWithOperator(this.operator, mapType.getValuesType(), this.value, mapElementValue);
            }
            ListType listType = (ListType)this.column.type;
            if (this.column.type.isMultiCell()) {
                ByteBuffer columnValue = ElementAccessBound.getListItem(ColumnCondition.getCells(row, this.column), ElementAccessBound.getListIndex(this.collectionElement));
                return this.compareWithOperator(this.operator, ((ListType)this.column.type).getElementsType(), this.value, columnValue);
            }
            Cell cell = ColumnCondition.getCell(row, this.column);
            ByteBuffer listElementValue = ((ListSerializer)listType.getSerializer()).getElement(cell.value(), ElementAccessBound.getListIndex(this.collectionElement));
            return this.compareWithOperator(this.operator, listType.getElementsType(), this.value, listElementValue);
        }

        static int getListIndex(ByteBuffer collectionElement) throws InvalidRequestException {
            int idx = ByteBufferUtil.toInt(collectionElement);
            if (idx < 0) {
                throw new InvalidRequestException(String.format("Invalid negative list index %d", idx));
            }
            return idx;
        }

        static ByteBuffer getListItem(Iterator<Cell> iter, int index) {
            int adv = Iterators.advance(iter, index);
            if (adv == index && iter.hasNext()) {
                return iter.next().value();
            }
            return null;
        }

        @Override
        public ByteBuffer getCollectionElementValue() {
            return this.collectionElement;
        }
    }

    static class SimpleInBound
    extends Bound {
        public final List<ByteBuffer> inValues;

        private SimpleInBound(ColumnCondition condition, QueryOptions options) throws InvalidRequestException {
            super(condition.column, condition.operator);
            assert (!(this.column.type instanceof CollectionType) && condition.collectionElement == null);
            assert (condition.operator == Operator.IN);
            if (condition.inValues == null) {
                this.inValues = ((Lists.Value)condition.value.bind(options)).getElements();
            } else {
                this.inValues = new ArrayList<ByteBuffer>(condition.inValues.size());
                for (Term value : condition.inValues) {
                    this.inValues.add(value.bindAndGet(options));
                }
            }
        }

        @Override
        public boolean appliesTo(Row row) throws InvalidRequestException {
            Cell c = ColumnCondition.getCell(row, this.column);
            for (ByteBuffer value : this.inValues) {
                if (!this.isSatisfiedByValue(value, c, this.column.type, Operator.EQ)) continue;
                return true;
            }
            return false;
        }
    }

    static class SimpleBound
    extends Bound {
        public final ByteBuffer value;

        private SimpleBound(ColumnCondition condition, QueryOptions options) throws InvalidRequestException {
            super(condition.column, condition.operator);
            assert (!(this.column.type instanceof CollectionType) && condition.collectionElement == null);
            assert (condition.operator != Operator.IN);
            this.value = condition.value.bindAndGet(options);
        }

        @Override
        public boolean appliesTo(Row row) throws InvalidRequestException {
            return this.isSatisfiedByValue(this.value, ColumnCondition.getCell(row, this.column), this.column.type, this.operator);
        }
    }

    public static abstract class Bound {
        public final ColumnDefinition column;
        public final Operator operator;

        protected Bound(ColumnDefinition column, Operator operator) {
            this.column = column;
            this.operator = operator;
        }

        public abstract boolean appliesTo(Row var1) throws InvalidRequestException;

        public ByteBuffer getCollectionElementValue() {
            return null;
        }

        protected boolean isSatisfiedByValue(ByteBuffer value, Cell c, AbstractType<?> type, Operator operator) throws InvalidRequestException {
            return this.compareWithOperator(operator, type, value, c == null ? null : c.value());
        }

        protected boolean compareWithOperator(Operator operator, AbstractType<?> type, ByteBuffer value, ByteBuffer otherValue) throws InvalidRequestException {
            if (value == ByteBufferUtil.UNSET_BYTE_BUFFER) {
                throw new InvalidRequestException("Invalid 'unset' value in condition");
            }
            if (value == null) {
                switch (operator) {
                    case EQ: {
                        return otherValue == null;
                    }
                    case NEQ: {
                        return otherValue != null;
                    }
                }
                throw new InvalidRequestException(String.format("Invalid comparison with null for operator \"%s\"", new Object[]{operator}));
            }
            if (otherValue == null) {
                return operator == Operator.NEQ;
            }
            return operator.isSatisfiedBy(type, otherValue, value);
        }
    }
}

