/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3;

import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnSpecification;
import com.github.cassandra.jdbc.internal.cassandra.cql3.QueryOptions;
import com.github.cassandra.jdbc.internal.cassandra.db.ConsistencyLevel;
import com.github.cassandra.jdbc.internal.cassandra.service.QueryState;
import com.github.cassandra.jdbc.internal.cassandra.utils.MD5Digest;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BatchQueryOptions {
    public static BatchQueryOptions DEFAULT = BatchQueryOptions.withoutPerStatementVariables(QueryOptions.DEFAULT);
    protected final QueryOptions wrapped;
    private final List<Object> queryOrIdList;

    protected BatchQueryOptions(QueryOptions wrapped, List<Object> queryOrIdList) {
        this.wrapped = wrapped;
        this.queryOrIdList = queryOrIdList;
    }

    public static BatchQueryOptions withoutPerStatementVariables(QueryOptions options) {
        return new WithoutPerStatementVariables(options, Collections.emptyList());
    }

    public static BatchQueryOptions withPerStatementVariables(QueryOptions options, List<List<ByteBuffer>> variables, List<Object> queryOrIdList) {
        return new WithPerStatementVariables(options, variables, queryOrIdList);
    }

    public abstract QueryOptions forStatement(int var1);

    public void prepareStatement(int i, List<ColumnSpecification> boundNames) {
        this.forStatement(i).prepare(boundNames);
    }

    public ConsistencyLevel getConsistency() {
        return this.wrapped.getConsistency();
    }

    public ConsistencyLevel getSerialConsistency() {
        return this.wrapped.getSerialConsistency();
    }

    public List<Object> getQueryOrIdList() {
        return this.queryOrIdList;
    }

    public long getTimestamp(QueryState state) {
        return this.wrapped.getTimestamp(state);
    }

    private static class WithPerStatementVariables
    extends BatchQueryOptions {
        private final List<QueryOptions> perStatementOptions;

        private WithPerStatementVariables(QueryOptions wrapped, List<List<ByteBuffer>> variables, List<Object> queryOrIdList) {
            super(wrapped, queryOrIdList);
            this.perStatementOptions = new ArrayList<QueryOptions>(variables.size());
            for (final List<ByteBuffer> vars : variables) {
                this.perStatementOptions.add(new QueryOptions.QueryOptionsWrapper(wrapped){

                    @Override
                    public List<ByteBuffer> getValues() {
                        return vars;
                    }
                });
            }
        }

        @Override
        public QueryOptions forStatement(int i) {
            return this.perStatementOptions.get(i);
        }

        @Override
        public void prepareStatement(int i, List<ColumnSpecification> boundNames) {
            if (this.isPreparedStatement(i)) {
                QueryOptions options = this.perStatementOptions.get(i);
                options.prepare(boundNames);
                options = QueryOptions.addColumnSpecifications(options, boundNames);
                this.perStatementOptions.set(i, options);
            } else {
                super.prepareStatement(i, boundNames);
            }
        }

        private boolean isPreparedStatement(int i) {
            return this.getQueryOrIdList().get(i) instanceof MD5Digest;
        }
    }

    private static class WithoutPerStatementVariables
    extends BatchQueryOptions {
        private WithoutPerStatementVariables(QueryOptions wrapped, List<Object> queryOrIdList) {
            super(wrapped, queryOrIdList);
        }

        @Override
        public QueryOptions forStatement(int i) {
            return this.wrapped;
        }
    }
}

