/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cql3;

import com.github.cassandra.jdbc.internal.cassandra.cql3.AssignmentTestable;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnIdentifier;
import com.github.cassandra.jdbc.internal.cassandra.cql3.ColumnSpecification;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Constants;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Lists;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Maps;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Sets;
import com.github.cassandra.jdbc.internal.cassandra.cql3.Term;
import com.github.cassandra.jdbc.internal.cassandra.cql3.VariableSpecifications;
import com.github.cassandra.jdbc.internal.cassandra.cql3.functions.Function;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.CollectionType;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.ListType;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.InvalidRequestException;
import java.util.Collections;

public abstract class AbstractMarker
extends Term.NonTerminal {
    protected final int bindIndex;
    protected final ColumnSpecification receiver;

    protected AbstractMarker(int bindIndex, ColumnSpecification receiver) {
        this.bindIndex = bindIndex;
        this.receiver = receiver;
    }

    @Override
    public void collectMarkerSpecification(VariableSpecifications boundNames) {
        boundNames.add(this.bindIndex, this.receiver);
    }

    @Override
    public boolean containsBindMarker() {
        return true;
    }

    @Override
    public Iterable<Function> getFunctions() {
        return Collections.emptySet();
    }

    public static class INRaw
    extends Raw {
        public INRaw(int bindIndex) {
            super(bindIndex);
        }

        private static ColumnSpecification makeInReceiver(ColumnSpecification receiver) {
            ColumnIdentifier inName = new ColumnIdentifier("in(" + receiver.name + ")", true);
            return new ColumnSpecification(receiver.ksName, receiver.cfName, inName, ListType.getInstance(receiver.type, false));
        }

        @Override
        public AbstractMarker prepare(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
            return new Lists.Marker(this.bindIndex, INRaw.makeInReceiver(receiver));
        }
    }

    public static abstract class MultiColumnRaw
    extends Term.MultiColumnRaw {
        protected final int bindIndex;

        public MultiColumnRaw(int bindIndex) {
            this.bindIndex = bindIndex;
        }

        @Override
        public Term.NonTerminal prepare(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
            throw new AssertionError((Object)"MultiColumnRaw..prepare() requires a list of receivers");
        }

        @Override
        public AssignmentTestable.TestResult testAssignment(String keyspace, ColumnSpecification receiver) {
            return AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
        }

        @Override
        public String getText() {
            return "?";
        }
    }

    public static class Raw
    extends Term.Raw {
        protected final int bindIndex;

        public Raw(int bindIndex) {
            this.bindIndex = bindIndex;
        }

        @Override
        public Term.NonTerminal prepare(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
            if (!(receiver.type instanceof CollectionType)) {
                return new Constants.Marker(this.bindIndex, receiver);
            }
            switch (((CollectionType)receiver.type).kind) {
                case LIST: {
                    return new Lists.Marker(this.bindIndex, receiver);
                }
                case SET: {
                    return new Sets.Marker(this.bindIndex, receiver);
                }
                case MAP: {
                    return new Maps.Marker(this.bindIndex, receiver);
                }
            }
            throw new AssertionError();
        }

        @Override
        public AssignmentTestable.TestResult testAssignment(String keyspace, ColumnSpecification receiver) {
            return AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
        }

        @Override
        public String getText() {
            return "?";
        }
    }
}

