/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.config;

import com.github.cassandra.jdbc.internal.cassandra.config.Config;
import com.github.cassandra.jdbc.internal.cassandra.config.ConfigurationLoader;
import com.github.cassandra.jdbc.internal.cassandra.config.DatabaseDescriptor;
import com.github.cassandra.jdbc.internal.cassandra.config.ParameterizedClass;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.ConfigurationException;
import com.github.cassandra.jdbc.internal.google.common.collect.Lists;
import com.github.cassandra.jdbc.internal.google.common.collect.Maps;
import com.github.cassandra.jdbc.internal.google.common.collect.Sets;
import com.github.cassandra.jdbc.internal.google.common.io.ByteStreams;
import com.github.cassandra.jdbc.internal.slf4j.Logger;
import com.github.cassandra.jdbc.internal.slf4j.LoggerFactory;
import com.github.cassandra.jdbc.internal.snakeyaml.TypeDescription;
import com.github.cassandra.jdbc.internal.snakeyaml.Yaml;
import com.github.cassandra.jdbc.internal.snakeyaml.constructor.Constructor;
import com.github.cassandra.jdbc.internal.snakeyaml.error.YAMLException;
import com.github.cassandra.jdbc.internal.snakeyaml.introspector.MissingProperty;
import com.github.cassandra.jdbc.internal.snakeyaml.introspector.Property;
import com.github.cassandra.jdbc.internal.snakeyaml.introspector.PropertyUtils;
import java.beans.IntrospectionException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class YamlConfigurationLoader
implements ConfigurationLoader {
    private static final Logger logger = LoggerFactory.getLogger(YamlConfigurationLoader.class);
    private static final String DEFAULT_CONFIGURATION = "cassandra.yaml";
    private static final URL storageConfigURL = YamlConfigurationLoader.getStorageConfigURL();

    private static URL getStorageConfigURL() throws ConfigurationException {
        URL url;
        block4: {
            String configUrl = System.getProperty("cassandra.config");
            if (configUrl == null) {
                configUrl = DEFAULT_CONFIGURATION;
            }
            try {
                url = new URL(configUrl);
                url.openStream().close();
            }
            catch (Exception e) {
                ClassLoader loader = DatabaseDescriptor.class.getClassLoader();
                url = loader.getResource(configUrl);
                if (url != null) break block4;
                String required = "file:" + File.separator + File.separator;
                if (!configUrl.startsWith(required)) {
                    throw new ConfigurationException(String.format("Expecting URI in variable: [cassandra.config]. Found[%s]. Please prefix the file with [%s%s] for local files and [%s<server>%s] for remote files. If you are executing this from an external tool, it needs to set Config.setClientMode(true) to avoid loading configuration.", configUrl, required, File.separator, required, File.separator));
                }
                throw new ConfigurationException("Cannot locate " + configUrl + ".  If this is a local file, please confirm you've provided " + required + File.separator + " as a URI prefix.");
            }
        }
        logger.info("Configuration location: {}", (Object)url);
        return url;
    }

    @Override
    public Config loadConfig() throws ConfigurationException {
        return this.loadConfig(storageConfigURL);
    }

    public Config loadConfig(URL url) throws ConfigurationException {
        try {
            byte[] configBytes;
            logger.debug("Loading settings from {}", (Object)url);
            try (InputStream is = url.openStream();){
                configBytes = ByteStreams.toByteArray(is);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            CustomConstructor constructor = new CustomConstructor(Config.class);
            MissingPropertiesChecker propertiesChecker = new MissingPropertiesChecker();
            constructor.setPropertyUtils(propertiesChecker);
            Yaml yaml = new Yaml(constructor);
            Config result = yaml.loadAs(new ByteArrayInputStream(configBytes), Config.class);
            propertiesChecker.check();
            return result;
        }
        catch (YAMLException e) {
            throw new ConfigurationException("Invalid yaml: " + url, e);
        }
    }

    private static class MissingPropertiesChecker
    extends PropertyUtils {
        private final Set<String> missingProperties = new HashSet<String>();

        public MissingPropertiesChecker() {
            this.setSkipMissingProperties(true);
        }

        @Override
        public Property getProperty(Class<? extends Object> type, String name) throws IntrospectionException {
            Property result = super.getProperty(type, name);
            if (result instanceof MissingProperty) {
                this.missingProperties.add(result.getName());
            }
            return result;
        }

        public void check() throws ConfigurationException {
            if (!this.missingProperties.isEmpty()) {
                throw new ConfigurationException("Invalid yaml. Please remove properties " + this.missingProperties + " from your cassandra.yaml");
            }
        }
    }

    static class CustomConstructor
    extends Constructor {
        CustomConstructor(Class<?> theRoot) {
            super(theRoot);
            TypeDescription seedDesc = new TypeDescription(ParameterizedClass.class);
            seedDesc.putMapPropertyType("parameters", String.class, String.class);
            this.addTypeDescription(seedDesc);
        }

        @Override
        protected List<Object> createDefaultList(int initSize) {
            return Lists.newCopyOnWriteArrayList();
        }

        @Override
        protected Map<Object, Object> createDefaultMap() {
            return Maps.newConcurrentMap();
        }

        @Override
        protected Set<Object> createDefaultSet(int initSize) {
            return Sets.newConcurrentHashSet();
        }

        @Override
        protected Set<Object> createDefaultSet() {
            return Sets.newConcurrentHashSet();
        }
    }
}

