/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.config;

import com.github.cassandra.jdbc.internal.cassandra.config.ParameterizedClass;
import com.github.cassandra.jdbc.internal.google.common.annotations.VisibleForTesting;
import com.github.cassandra.jdbc.internal.google.common.base.Objects;

public class TransparentDataEncryptionOptions {
    public boolean enabled = false;
    public int chunk_length_kb = 64;
    public String cipher = "AES/CBC/PKCS5Padding";
    public String key_alias;
    public int iv_length = 16;
    public ParameterizedClass key_provider;

    public TransparentDataEncryptionOptions() {
    }

    public TransparentDataEncryptionOptions(boolean enabled) {
        this.enabled = enabled;
    }

    public TransparentDataEncryptionOptions(String cipher, String keyAlias, ParameterizedClass keyProvider) {
        this(true, cipher, keyAlias, keyProvider);
    }

    public TransparentDataEncryptionOptions(boolean enabled, String cipher, String keyAlias, ParameterizedClass keyProvider) {
        this.enabled = enabled;
        this.cipher = cipher;
        this.key_alias = keyAlias;
        this.key_provider = keyProvider;
    }

    public String get(String key) {
        return this.key_provider.parameters.get(key);
    }

    @VisibleForTesting
    public void remove(String key) {
        this.key_provider.parameters.remove(key);
    }

    public boolean equals(Object o) {
        return o instanceof TransparentDataEncryptionOptions && this.equals((TransparentDataEncryptionOptions)o);
    }

    public boolean equals(TransparentDataEncryptionOptions other) {
        return Objects.equal(this.cipher, other.cipher) && Objects.equal(this.key_alias, other.key_alias);
    }
}

