/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cache;

import com.github.cassandra.jdbc.internal.cassandra.cache.CacheProvider;
import com.github.cassandra.jdbc.internal.cassandra.cache.ICache;
import com.github.cassandra.jdbc.internal.cassandra.cache.IRowCacheEntry;
import com.github.cassandra.jdbc.internal.cassandra.cache.RowCacheKey;
import com.github.cassandra.jdbc.internal.cassandra.cache.RowCacheSentinel;
import com.github.cassandra.jdbc.internal.cassandra.cache.SerializingCache;
import com.github.cassandra.jdbc.internal.cassandra.config.DatabaseDescriptor;
import com.github.cassandra.jdbc.internal.cassandra.db.TypeSizes;
import com.github.cassandra.jdbc.internal.cassandra.db.partitions.CachedPartition;
import com.github.cassandra.jdbc.internal.cassandra.io.ISerializer;
import com.github.cassandra.jdbc.internal.cassandra.io.util.DataInputPlus;
import com.github.cassandra.jdbc.internal.cassandra.io.util.DataOutputPlus;
import java.io.IOException;

public class SerializingCacheProvider
implements CacheProvider<RowCacheKey, IRowCacheEntry> {
    @Override
    public ICache<RowCacheKey, IRowCacheEntry> create() {
        return SerializingCache.create(DatabaseDescriptor.getRowCacheSizeInMB() * 1024L * 1024L, new RowCacheSerializer());
    }

    static class RowCacheSerializer
    implements ISerializer<IRowCacheEntry> {
        RowCacheSerializer() {
        }

        public void serialize(IRowCacheEntry entry, DataOutputPlus out) throws IOException {
            assert (entry != null);
            boolean isSentinel = entry instanceof RowCacheSentinel;
            out.writeBoolean(isSentinel);
            if (isSentinel) {
                out.writeLong(((RowCacheSentinel)entry).sentinelId);
            } else {
                CachedPartition.cacheSerializer.serialize((Object)((CachedPartition)entry), out);
            }
        }

        public IRowCacheEntry deserialize(DataInputPlus in) throws IOException {
            boolean isSentinel = in.readBoolean();
            if (isSentinel) {
                return new RowCacheSentinel(in.readLong());
            }
            return (IRowCacheEntry)CachedPartition.cacheSerializer.deserialize(in);
        }

        public long serializedSize(IRowCacheEntry entry) {
            int size = TypeSizes.sizeof((boolean)true);
            size = entry instanceof RowCacheSentinel ? (size += TypeSizes.sizeof((long)((RowCacheSentinel)entry).sentinelId)) : (int)((long)size + CachedPartition.cacheSerializer.serializedSize((Object)((CachedPartition)entry)));
            return size;
        }
    }
}

