/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cache;

import com.github.cassandra.jdbc.internal.cassandra.io.util.Memory;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class RefCountedMemory
extends Memory
implements AutoCloseable {
    private volatile int references = 1;
    private static final AtomicIntegerFieldUpdater<RefCountedMemory> UPDATER = AtomicIntegerFieldUpdater.newUpdater(RefCountedMemory.class, "references");

    public RefCountedMemory(long size) {
        super(size);
    }

    public boolean reference() {
        int n;
        do {
            if ((n = UPDATER.get(this)) > 0) continue;
            return false;
        } while (!UPDATER.compareAndSet(this, n, n + 1));
        return true;
    }

    public void unreference() {
        if (UPDATER.decrementAndGet(this) == 0) {
            super.free();
        }
    }

    @Override
    public RefCountedMemory copy(long newSize) {
        RefCountedMemory copy = new RefCountedMemory(newSize);
        copy.put(0L, this, 0L, Math.min(this.size(), newSize));
        return copy;
    }

    @Override
    public void free() {
        throw new AssertionError();
    }

    @Override
    public void close() {
        this.unreference();
    }
}

