/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.cache;

import com.github.cassandra.jdbc.internal.cassandra.cache.CacheKey;
import com.github.cassandra.jdbc.internal.cassandra.io.sstable.Descriptor;
import com.github.cassandra.jdbc.internal.cassandra.utils.ByteBufferUtil;
import com.github.cassandra.jdbc.internal.cassandra.utils.ObjectSizes;
import com.github.cassandra.jdbc.internal.cassandra.utils.Pair;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class KeyCacheKey
extends CacheKey {
    public final Descriptor desc;
    private static final long EMPTY_SIZE = ObjectSizes.measure(new KeyCacheKey(null, null, ByteBufferUtil.EMPTY_BYTE_BUFFER));
    public final byte[] key;

    public KeyCacheKey(Pair<String, String> ksAndCFName, Descriptor desc, ByteBuffer key) {
        super(ksAndCFName);
        this.desc = desc;
        this.key = ByteBufferUtil.getArray(key);
        assert (this.key != null);
    }

    public String toString() {
        return String.format("KeyCacheKey(%s, %s)", this.desc, ByteBufferUtil.bytesToHex(ByteBuffer.wrap(this.key)));
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE + ObjectSizes.sizeOfArray(this.key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyCacheKey that = (KeyCacheKey)o;
        return this.ksAndCFName.equals(that.ksAndCFName) && this.desc.equals((Object)that.desc) && Arrays.equals(this.key, that.key);
    }

    public int hashCode() {
        int result = this.ksAndCFName.hashCode();
        result = 31 * result + this.desc.hashCode();
        result = 31 * result + Arrays.hashCode(this.key);
        return result;
    }
}

