/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.auth;

import com.github.cassandra.jdbc.internal.cassandra.auth.AuthCache;
import com.github.cassandra.jdbc.internal.cassandra.auth.AuthenticatedUser;
import com.github.cassandra.jdbc.internal.cassandra.auth.IAuthorizer;
import com.github.cassandra.jdbc.internal.cassandra.auth.IResource;
import com.github.cassandra.jdbc.internal.cassandra.auth.Permission;
import com.github.cassandra.jdbc.internal.cassandra.auth.PermissionsCacheMBean;
import com.github.cassandra.jdbc.internal.cassandra.config.DatabaseDescriptor;
import com.github.cassandra.jdbc.internal.cassandra.utils.Pair;
import java.util.Set;
import java.util.concurrent.ExecutionException;

public class PermissionsCache
extends AuthCache<Pair<AuthenticatedUser, IResource>, Set<Permission>>
implements PermissionsCacheMBean {
    public PermissionsCache(IAuthorizer authorizer) {
        super("PermissionsCache", DatabaseDescriptor::setPermissionsValidity, DatabaseDescriptor::getPermissionsValidity, DatabaseDescriptor::setPermissionsUpdateInterval, DatabaseDescriptor::getPermissionsUpdateInterval, DatabaseDescriptor::setPermissionsCacheMaxEntries, DatabaseDescriptor::getPermissionsCacheMaxEntries, p -> authorizer.authorize((AuthenticatedUser)p.left, (IResource)p.right), () -> DatabaseDescriptor.getAuthorizer().requireAuthorization());
    }

    public Set<Permission> getPermissions(AuthenticatedUser user, IResource resource) {
        try {
            return (Set)this.get(Pair.create(user, resource));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

