/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.auth;

import com.github.cassandra.jdbc.internal.cassandra.auth.AuthCache;
import com.github.cassandra.jdbc.internal.cassandra.auth.AuthCacheMBean;
import com.github.cassandra.jdbc.internal.cassandra.auth.AuthenticatedUser;
import com.github.cassandra.jdbc.internal.cassandra.auth.CassandraRoleManager;
import com.github.cassandra.jdbc.internal.cassandra.auth.DataResource;
import com.github.cassandra.jdbc.internal.cassandra.auth.IAuthenticator;
import com.github.cassandra.jdbc.internal.cassandra.config.DatabaseDescriptor;
import com.github.cassandra.jdbc.internal.cassandra.config.Schema;
import com.github.cassandra.jdbc.internal.cassandra.cql3.QueryOptions;
import com.github.cassandra.jdbc.internal.cassandra.cql3.QueryProcessor;
import com.github.cassandra.jdbc.internal.cassandra.cql3.UntypedResultSet;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.SelectStatement;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.AuthenticationException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.ConfigurationException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.RequestExecutionException;
import com.github.cassandra.jdbc.internal.cassandra.service.ClientState;
import com.github.cassandra.jdbc.internal.cassandra.service.QueryState;
import com.github.cassandra.jdbc.internal.cassandra.transport.messages.ResultMessage;
import com.github.cassandra.jdbc.internal.cassandra.utils.ByteBufferUtil;
import com.github.cassandra.jdbc.internal.google.common.collect.ImmutableSet;
import com.github.cassandra.jdbc.internal.google.common.collect.Lists;
import com.github.cassandra.jdbc.internal.google.common.util.concurrent.UncheckedExecutionException;
import com.github.cassandra.jdbc.internal.slf4j.Logger;
import com.github.cassandra.jdbc.internal.slf4j.LoggerFactory;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.mindrot.jbcrypt.BCrypt;

public class PasswordAuthenticator
implements IAuthenticator {
    private static final Logger logger = LoggerFactory.getLogger(PasswordAuthenticator.class);
    private static final String SALTED_HASH = "salted_hash";
    public static final String USERNAME_KEY = "username";
    public static final String PASSWORD_KEY = "password";
    private static final byte NUL = 0;
    private SelectStatement authenticateStatement;
    public static final String LEGACY_CREDENTIALS_TABLE = "credentials";
    private SelectStatement legacyAuthenticateStatement;
    private CredentialsCache cache;

    @Override
    public boolean requireAuthentication() {
        return true;
    }

    private AuthenticatedUser authenticate(String username, String password) throws AuthenticationException {
        try {
            String hash = (String)this.cache.get(username);
            if (!BCrypt.checkpw((String)password, (String)hash)) {
                throw new AuthenticationException("Username and/or password are incorrect");
            }
            return new AuthenticatedUser(username);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            if (e.getCause() instanceof NoSuchCredentialsException) {
                throw new AuthenticationException("Username and/or password are incorrect");
            }
            if (e.getCause() instanceof RequestExecutionException) {
                logger.trace("Error performing internal authentication", e);
                throw new AuthenticationException(e.getMessage());
            }
            throw new RuntimeException(e);
        }
    }

    private String queryHashedPassword(String username) throws NoSuchCredentialsException {
        try {
            SelectStatement authenticationStatement = Schema.instance.getCFMetaData("system_auth", LEGACY_CREDENTIALS_TABLE) == null ? this.authenticateStatement : this.legacyAuthenticateStatement;
            ResultMessage.Rows rows = authenticationStatement.execute(QueryState.forInternalCalls(), QueryOptions.forInternalCalls(CassandraRoleManager.consistencyForRole(username), Lists.newArrayList(ByteBufferUtil.bytes(username))));
            if (rows.result.isEmpty()) {
                throw new NoSuchCredentialsException();
            }
            UntypedResultSet result = UntypedResultSet.create(rows.result);
            if (!result.one().has(SALTED_HASH)) {
                throw new NoSuchCredentialsException();
            }
            return result.one().getString(SALTED_HASH);
        }
        catch (RequestExecutionException e) {
            logger.trace("Error performing internal authentication", e);
            throw e;
        }
    }

    public Set<DataResource> protectedResources() {
        return ImmutableSet.of(DataResource.table("system_auth", "roles"));
    }

    @Override
    public void validateConfiguration() throws ConfigurationException {
    }

    @Override
    public void setup() {
        String query = String.format("SELECT %s FROM %s.%s WHERE role = ?", SALTED_HASH, "system_auth", "roles");
        this.authenticateStatement = PasswordAuthenticator.prepare(query);
        if (Schema.instance.getCFMetaData("system_auth", LEGACY_CREDENTIALS_TABLE) != null) {
            query = String.format("SELECT %s from %s.%s WHERE username = ?", SALTED_HASH, "system_auth", LEGACY_CREDENTIALS_TABLE);
            this.legacyAuthenticateStatement = PasswordAuthenticator.prepare(query);
        }
        this.cache = new CredentialsCache(this);
    }

    @Override
    public AuthenticatedUser legacyAuthenticate(Map<String, String> credentials) throws AuthenticationException {
        String username = credentials.get(USERNAME_KEY);
        if (username == null) {
            throw new AuthenticationException(String.format("Required key '%s' is missing", USERNAME_KEY));
        }
        String password = credentials.get(PASSWORD_KEY);
        if (password == null) {
            throw new AuthenticationException(String.format("Required key '%s' is missing", PASSWORD_KEY));
        }
        return this.authenticate(username, password);
    }

    @Override
    public IAuthenticator.SaslNegotiator newSaslNegotiator(InetAddress clientAddress) {
        return new PlainTextSaslAuthenticator();
    }

    private static SelectStatement prepare(String query) {
        return (SelectStatement)QueryProcessor.getStatement((String)query, (ClientState)ClientState.forInternalCalls()).statement;
    }

    private static final class NoSuchCredentialsException
    extends RuntimeException {
        private NoSuchCredentialsException() {
        }
    }

    public static interface CredentialsCacheMBean
    extends AuthCacheMBean {
        public void invalidateCredentials(String var1);
    }

    private static class CredentialsCache
    extends AuthCache<String, String>
    implements CredentialsCacheMBean {
        private CredentialsCache(PasswordAuthenticator authenticator) {
            super("CredentialsCache", DatabaseDescriptor::setCredentialsValidity, DatabaseDescriptor::getCredentialsValidity, DatabaseDescriptor::setCredentialsUpdateInterval, DatabaseDescriptor::getCredentialsUpdateInterval, DatabaseDescriptor::setCredentialsCacheMaxEntries, DatabaseDescriptor::getCredentialsCacheMaxEntries, x$0 -> authenticator.queryHashedPassword(x$0), () -> true);
        }

        @Override
        public void invalidateCredentials(String roleName) {
            this.invalidate(roleName);
        }
    }

    private class PlainTextSaslAuthenticator
    implements IAuthenticator.SaslNegotiator {
        private boolean complete = false;
        private String username;
        private String password;

        private PlainTextSaslAuthenticator() {
        }

        @Override
        public byte[] evaluateResponse(byte[] clientResponse) throws AuthenticationException {
            this.decodeCredentials(clientResponse);
            this.complete = true;
            return null;
        }

        @Override
        public boolean isComplete() {
            return this.complete;
        }

        @Override
        public AuthenticatedUser getAuthenticatedUser() throws AuthenticationException {
            if (!this.complete) {
                throw new AuthenticationException("SASL negotiation not complete");
            }
            return PasswordAuthenticator.this.authenticate(this.username, this.password);
        }

        private void decodeCredentials(byte[] bytes) throws AuthenticationException {
            logger.trace("Decoding credentials from client token");
            byte[] user = null;
            byte[] pass = null;
            int end = bytes.length;
            for (int i = bytes.length - 1; i >= 0; --i) {
                if (bytes[i] != 0) continue;
                if (pass == null) {
                    pass = Arrays.copyOfRange(bytes, i + 1, end);
                } else if (user == null) {
                    user = Arrays.copyOfRange(bytes, i + 1, end);
                }
                end = i;
            }
            if (pass == null) {
                throw new AuthenticationException("Password must not be null");
            }
            if (user == null) {
                throw new AuthenticationException("Authentication ID must not be null");
            }
            this.username = new String(user, StandardCharsets.UTF_8);
            this.password = new String(pass, StandardCharsets.UTF_8);
        }
    }
}

